/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class ErrorHandler
extends AbstractHandler {
    boolean _showStacks = true;

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        HttpConnection.getCurrentConnection().getRequest().setHandled(true);
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
        HttpConnection connection = HttpConnection.getCurrentConnection();
        this.handleErrorPage(request, (Writer)writer, connection.getResponse().getStatus(), connection.getResponse().getReason());
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo((OutputStream)response.getOutputStream());
        writer.destroy();
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        ErrorHandler.writeErrorPage(request, writer, code, message, this._showStacks);
    }

    public static void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        if (message != null) {
            message = URLDecoder.decode(message, "UTF-8");
            message = StringUtil.replace((String)message, (String)"<", (String)"&lt;");
            message = StringUtil.replace((String)message, (String)">", (String)"&gt;");
        }
        String uri = request.getRequestURI();
        uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
        uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
        writer.write("<html>\n<head>\n<title>Error ");
        writer.write(Integer.toString(code));
        writer.write(32);
        if (message == null) {
            message = HttpGenerator.getReason(code);
        }
        writer.write(message);
        writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
        writer.write(Integer.toString(code));
        writer.write("</h2><pre>");
        writer.write(message);
        writer.write("</pre>\n");
        writer.write("<p>RequestURI=");
        writer.write(uri);
        writer.write("</p>\n<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by Jetty://</a></small></i></p>");
        if (showStacks) {
            for (Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception"); th != null; th = th.getCause()) {
                writer.write("<h3>Caused by:</h2><pre>");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                th.printStackTrace(pw);
                pw.flush();
                writer.write(sw.getBuffer().toString());
                writer.write("</pre>\n");
            }
        }
        for (int i = 0; i < 20; ++i) {
            writer.write("\n                                                ");
        }
        writer.write("\n</body>\n</html>\n");
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this._showStacks = showStacks;
    }
}

