/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.beantree;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;


/**
 * Bean TreeɂO[v\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class BeanTreeGroup extends AbstractBeanNode {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;
    /*
     * O[vɏqm[hێMap
     */
    private Set<IBeanNode> children = new HashSet<IBeanNode>();

    private String name;
    /**
     * Bean TreeɂO[v\NX
     * CX^X𐶐܂B
     */
    public BeanTreeGroup() {
    }

    /**
     * Bean TreeɂO[v\NXCX^Xw肵O[vɂĐ܂B
     *
     * @param name O[v
     */
    public BeanTreeGroup(String name) {
        setName(name);
        this.name = name;
    }

    /**
     * m[hԂ܂B
     *
     * @return name m[h
     */
    public String getName() {
        return name;
    }
    
    /**
     * qm[hԂ܂B
     *
     * @return qm[h
     */
    public IBeanNode[] getChildren() {
        return (IBeanNode[]) children.toArray(new IBeanNode[children.size()]);
    }

    /**
     * ImageԂ܂B
     *
     * @return Image
     */
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage(
            ISharedImages.IMG_OBJ_FOLDER);
    }

    /**
     * qm[hǉ܂B
     *
     * @param toAdd ǉqm[h
     */
    public void addChild(IBeanNode toAdd) {
        children.add(toAdd);
        toAdd.setParent(this);
    }

    /**
     * O[vǉ܂B
     *
     * @param toAddGroup ǉO[v
     * @return toAddGroup ǉO[v
     */
    public BeanTreeGroup addGroup(BeanTreeGroup toAddGroup) {
        children.add(toAddGroup);
        toAddGroup.setParent(this);

        return toAddGroup;
    }

    /**
     * qm[h݂邩Ԃ܂B
     *
     * @return qm[h݂邩tO
     */
    public boolean hasChildren() {
        return !children.isEmpty();
    }

    /**
     * qm[h폜܂B
     *
     * @param toRemove 폜qm[h
     */
    public void removeChild(IBeanNode toRemove) {
        children.remove(toRemove);
    }

    /**
     * SĂ̎qm[h폜܂B
     *
     */
    public void removeChildAll() {
        children.clear();
    }
}
