/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.beantree;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Text;

/**
 * Bean Tree Clickł̃Xi[NXłB
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class BeanTreeListener implements ISelectionChangedListener {

	private Text beanText;

	private BeanTreeListener() {
		
	}


	public void selectionChanged(SelectionChangedEvent event) {

		StructuredSelection ss = (StructuredSelection) event.getSelection();
		if (ss.getFirstElement() instanceof BeanTree) {
			final BeanTree entry = (BeanTree) ss.getFirstElement();
			beanText.setText(entry.getName());
		} else if (ss.getFirstElement() instanceof BeanTreeGroup){
			final BeanTreeGroup entry = (BeanTreeGroup) ss.getFirstElement();
			beanText.setText(entry.getName());
		}

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static BeanTreeListener getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final BeanTreeListener RESOURCE = new BeanTreeListener();
	}

	public void setBeanText(Text beanText) {
		this.beanText = beanText;
	}
}
