/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.gui;

import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.jmx.beantree.BeanTree;
import netjfwatcher.jmx.beantree.BeanTreeGroup;
import netjfwatcher.jmx.beantree.BeanTreeListener;
import netjfwatcher.jmx.beantree.BeanTreeViewContentProvider;
import netjfwatcher.jmx.beantree.BeanTreeViewLabelProvider;
import netjfwatcher.jmx.beantree.BeanTreeViewSorter;
import netjfwatcher.jmx.beantree.IBeanNode;
import netjfwatcher.jmx.model.JMXBeanDefine;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Node;

/**
 * lbg[NĎj[View\NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JMXBeanMenuView extends ViewPart {
	/* EditorsPartANVBuilder */
	private static ActionBuilderEditorsPartClose actionBuilder = new ActionBuilderEditorsPartClose();

	/* TreeViewer */
	private static TreeViewer beanTreeViewer;

	/**
	 * lbg[NĎj[View̃CX^X𐶐܂B
	 * 
	 */
	public JMXBeanMenuView() {
		// nothing
	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderEditorsPartClose getActionBuilder() {
		return actionBuilder;
	}

	/**
	 * tH[JXZbgꂽꍇ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return menuTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return beanTreeViewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* j[Tree */
		beanTreeViewer = new TreeViewer(parent);
		beanTreeViewer.setUseHashlookup(true);
		beanTreeViewer.setContentProvider(new BeanTreeViewContentProvider());
		beanTreeViewer.setLabelProvider(new BeanTreeViewLabelProvider());

		/* j[Tree\[^[Zbg */
		beanTreeViewer.setSorter(new BeanTreeViewSorter());

		/* Viewerɓ̓f[^ݒ */
		beanTreeViewer.setInput(createInitialInput());
		beanTreeViewer.expandAll();

		/* j[Zbg */
		createContextMenu();

		/* ANVZbg */
		initActions();

		createNetworkMenuTree();

		/* Nodej[ View̃Xi[ݒ */
		setupBeanViewListener();
	}

	/**
	 * Nodej[View̃Xi[o^s܂B Xi[Tree\j[Click̏łB
	 * 
	 */
	private void setupBeanViewListener() {
		/*
		 * j[Tree ViewɃXi[o^ iTree\j[Click̏j
		 */
		beanTreeViewer.addSelectionChangedListener(BeanTreeListener
				.getInstance());
	}

	/**
	 * ViewerݒpIuWFNg𐶐ĕԂ܂B
	 * 
	 * 
	 * @return rootOfRoot Object
	 */
	private Object createInitialInput() {
		BeanTreeGroup rootOfRoot = new RootOfRootMenuGroup();

		return rootOfRoot;
	}

	/**
	 * ContextMenuZbg܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {

		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().actionCloseAllEditors());
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		menuManager.addMenuListener(new IMenuListener() {
			/**
			 * j[I
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* j[}l[WZbg */
		Menu menu = menuManager.createContextMenu(beanTreeViewer.getControl());
		beanTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, beanTreeViewer);
	}

	/**
	 * ANV̏s܂B
	 * 
	 */
	private void initActions() {

		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		// Editor Pats closeANV
		toolBarManager.add(getActionBuilder().actionCloseAllEditors());
	}


	public void createNetworkMenuTree() {

		IBeanNode menuNode = (IBeanNode) getViewer().getInput();
		BeanTreeGroup baseMenuGroup = menuNode.getParent();

		if (menuNode instanceof BeanTreeGroup) {
			baseMenuGroup = (BeanTreeGroup) menuNode;

		}

		BeanTreeGroup beanGroup = new BeanTreeGroup(JMXBeanDefine.MXBEAN);
		baseMenuGroup.addGroup(beanGroup);

		beanGroup.addChild(new BeanTree(JMXBeanDefine.OPERATING_SYSTEM_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.RUNTIME_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.COMPILATION_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.CLASS_LOADING_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.THREAD_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.GARBAGECOLLECTOR_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.MEMORY_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.MEMORY_MANAGER_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.MEMORY_POOL_MXBEAN));
		beanGroup.addChild(new BeanTree(JMXBeanDefine.LOGGING_MXBEAN));
		beanTreeViewer.expandAll();
		beanTreeViewer.refresh();

	}

	/**
	 * u{́vŏʃO[vBgetParentnullԂAr[ɂ ȂỹO[vB
	 */
	private static final class RootOfRootMenuGroup extends BeanTreeGroup {

		RootOfRootMenuGroup() {
			super("RootOfRoot");

		}

		/**
		 * eO[vԂ܂B
		 * 
		 * @return eO[v
		 */
		public BeanTreeGroup getParent() {

			return null;
		}

		/**
		 * qm[h폜܂B
		 * 
		 * @param toRemove
		 *            Node
		 */
		public void removeChild(Node toRemove) {
			// ROOT O[vƍB
		}
	}
}
