/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.gui;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.jmx.beantree.BeanTreeListener;
import netjfwatcher.jmx.model.JMXBeanDefine;
import netjfwatcher.jmx.model.JMXBeanTableTimerProcessor;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;


/**
 * JMX Bean̎ ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JMXBeanOperationView extends ViewPart {
	

	private static final String GET_BUTTON_LABEL = "Get";

	private static final String CLEAR_TABLE_BUTTON_LABEL = "Clear";
	
    private static final int TEXT_WIDTH = 200;

	private static final String HOST_NAME = "127.0.0.1";

	private static final String PORT_NUM = "9999";
	
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 200 };

	private Text targetIPText;

	private Text portText;

	private Text beanText;
	
	private Combo sslCombo;

	private Button getButton;

	private Button clearTableButton;
	
	private Color textBackColor;

    private SubStatusLineManager statusLineManager;

	private JMXBeanTableTimerProcessor timerProcessor;


	/* Display */
	private Display display;
	
    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
		display = parent.getDisplay();
        /* Xe[^XC\Zbg */
        setStatusLine();

        /* textwiFZbg  */
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);


        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.NULL);

        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        GridData gridData = null;

        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Host Address");
        label.setLayoutData(new GridData());
        targetIPText = new Text(composite, SWT.BORDER);
        targetIPText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        targetIPText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Port");
        label.setLayoutData(new GridData());
        portText = new Text(composite, SWT.BORDER);
        portText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        portText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Bean");
        label.setLayoutData(new GridData());
        beanText = new Text(composite, SWT.BORDER);
        beanText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        beanText.setLayoutData(gridData);
        
        /* SSL Type */
        label = new Label(composite, SWT.NONE);
        label.setText("SSL");
        gridData = new GridData();
        label.setLayoutData(gridData);

        sslCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        sslCombo.add("false");
        sslCombo.select(0);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        sslCombo.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(2, false);
        Composite composite2 = new Composite(baseComposite, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        getButton = new Button(composite2, SWT.NONE);
        getButton.setText(GET_BUTTON_LABEL);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        getButton.setLayoutData(gridData);

        clearTableButton = new Button(composite2, SWT.NONE);
        clearTableButton.setText(CLEAR_TABLE_BUTTON_LABEL);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        clearTableButton.setLayoutData(gridData);



        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);


        getButton.addSelectionListener(
            new SelectionListener() {

                public void widgetSelected(SelectionEvent event) {
                	getButton.setEnabled(false);
                	try {
						int port = Integer.parseInt(portText.getText());
					} catch (NumberFormatException e1) {
						MessageDialog.openError(getSite().getShell(), "Error", "Illegal Port=" +  portText.getText());
						portText.setFocus();
						getButton.setEnabled(true);
						return;
					}
					try {
						JMXMXBeanCollector.getInstance().getMXBeanInfo(
								targetIPText.getText(), portText.getText(),
								beanText.getText());
					} catch (Exception e) {

		                MessageDialog.openError(getSite().getShell(), "Error", "Host=" + targetIPText.getText() + " Port=" +  portText.getText() + " " + e.getMessage());
		               
					}            		
					getButton.setEnabled(true);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        clearTableButton.addSelectionListener(
                new SelectionListener() {

                    public void widgetSelected(SelectionEvent event) {
                    	clearTableButton.setEnabled(false);
                    	Table beanTable = JMXBeanTableTimerProcessor.getInstance().getBeanTable();
                    	TableViewer viewer = JMXBeanTableTimerProcessor.getInstance().getViewer();
                    	if(beanTable != null && viewer != null) {
                    		beanTable.removeAll();
                    		viewer.refresh();
                    	}
                		clearTableButton.setEnabled(true);
                    }

                    /*
                     *  (non-Javadoc)
                     * @see org.eclipse.swt.events.
                     * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                     */
                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
        
        setText();
        startTimer();

        BeanTreeListener.getInstance().setBeanText(beanText);
    }


    private void setText() {
    	targetIPText.setText(HOST_NAME);
    	portText.setText(PORT_NUM);
    	beanText.setText(JMXBeanDefine.OPERATING_SYSTEM_MXBEAN);
    }
    
    private void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        int snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
        String snmpV1Timeout =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV1Timeout();
        String snmpV1Retry =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV1Retry();

        statusLineManager.setMessage(
            "Snmp Port=" + snmpPort + " timeout=" + snmpV1Timeout + " retry="
            + snmpV1Retry);
    }
    
    
	private void startTimer() {
		/* TrapMf[^\^C}[̐As */
		JMXBeanTableTimerProcessor.getInstance().setDisplay(display);
		timerProcessor = JMXBeanTableTimerProcessor.getInstance();
		display.timerExec(JMXBeanTableTimerProcessor.TIMER, timerProcessor);
	}

    /**
    * tH[JXZbgꂽ̏łB
    */
    public void setFocus() {
    }
}
