/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.gui.snmp;

import java.util.ArrayList;
import java.util.HashMap;

import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpmanager.OidTreeListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class JMXSnmpOIDTreeView extends ViewPart {

    /**
     * OID Treẽm[h/[tɂăm[hǂ܂expandiJj
     * 邩̏l
     */
    public static final int EXPANDED_LEVEL = 2;

    /** OID TreełOID TreeIl(system.sysDesc) */
    public static final String INIT_SELECT_OID = "1.3.6.1.4.1.42";

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {

    	ManagerJMXSnmpMibTree oidTreeInstance = ManagerJMXSnmpMibTree.getInstance();
        ArrayList oidList = oidTreeInstance.getOidList();

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;

        /* TreeEBWFbg𐶐 */
        final Tree tree = new Tree(parent, SWT.BORDER);
        TreeItem roottWork = new TreeItem(tree, SWT.NULL);
        MibInfo rootOidInfo = (MibInfo) oidList.get(0);
        String rootOid = ((MibInfo) oidList.get(0)).getOid();
        String rootDescrip = ((MibInfo) oidList.get(0)).getDescrip();
        roottWork.setText(rootDescrip + "(" + rootOid + ")");
        roottWork.setData(rootOidInfo);


        HashMap<String, TreeItem> oidTreeMap = new HashMap<String, TreeItem>();
        oidTreeMap.put(rootOid, roottWork);

        /*
         * MIB`Xg TreeItem𐶐
         */
        for (int i = 0; i < oidList.size(); i++) {
            MibInfo oidInfo = (MibInfo) oidList.get(i);
            String oid = ((MibInfo) oidList.get(i)).getOid();
            String oidDiscrip = ((MibInfo) oidList.get(i)).getDescrip();
            String parentOid = ((MibInfo) oidList.get(i)).getParentOid();

            /*
             *
             */
            if (oidTreeMap.containsKey(parentOid)) {
                TreeItem parentTreeItem = (TreeItem) oidTreeMap.get(parentOid);
                TreeItem treeItem = new TreeItem(parentTreeItem, SWT.NULL);
                treeItem.setText(oidDiscrip + "(" + oid + ")");
                treeItem.setData(oidInfo);

                oidTreeMap.put(oid, treeItem);
            }
        }

        /*
         * Tree NodeKȃx܂œWJiJj
         */
        TreeItem[] treeItems = new TreeItem[1];

        for (int i = 0; i < EXPANDED_LEVEL; i++) {
            String workOid = ((MibInfo) oidList.get(i)).getOid();

            TreeItem expandTreeItem = (TreeItem) oidTreeMap.get(workOid);

            // Tree NodeWJ
            expandTreeItem.setExpanded(true);

            if (i == 0) {
                treeItems[0] = expandTreeItem;
            }
        }

        tree.setLayoutData(gridData);

        /* OID TreeI */
        tree.setSelection(treeItems);

        /*
         * OID TreeIXi[Zbg
         */
        tree.addSelectionListener(OidTreeListener.getInstance());
    }


    public void setFocus() {
    }
}
