/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.gui.table;

import netjfwatcher.application.NetJFWatcherApplication;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;



/**
 * SNMP}l[W OIDe[uIXi[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JMXMXBeanTableListener extends SelectionAdapter {
    /* OIDe[u */
    private final Table managerOidTable;

    /* Manager OIDe[ȗIOID Description */
    private String selectOidDescription;

    /* Manager OIDe[ȗIOID */
    private String selectOid;

    /* Manager OIDe[ȗIOID̒l */
    private String selectValue;

    /* Manager OIDe[ȗIOIDType */
    private String selectType;

    /* Manager OIDe[ȗIOIDAccess */
    private String selectAccess;

    /**
     * SNMP}l[W CX^Xe[uXi[NX
     * CX^X𐶐܂B
     *
     * @param table Table
     */
    public JMXMXBeanTableListener(Table table) {
        this.managerOidTable = table;
    }

    /**
     * TableIłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        /* e[uIs(Row)o */
        int index = managerOidTable.getSelectionIndex();

        if (index == -1) {
            return;
        }

        // TablȇI͈͂
        // table.setSelection(new int[0]);
        // Iꂽs(Row)TableItem擾
        TableItem item = managerOidTable.getItem(index);
        selectOidDescription = item.getText(JMXMXBeanTableViewLabelProvider.BEAN_NAME_COLUMN_NO);
        selectOid = item.getText(JMXMXBeanTableViewLabelProvider.ATTRIBUTE_COLUMN_NO);
        selectValue = item.getText(JMXMXBeanTableViewLabelProvider.VALUE_COLUMN_NO);
        selectType = item.getText(JMXMXBeanTableViewLabelProvider.TYPE_COLUMN_NO);
        selectAccess = item.getText(JMXMXBeanTableViewLabelProvider.ACCESS_COLUMN_NO);

        updateManagerOperationView();
    }

    /*
     * OIDe[uőIꂽOID𑀍r[ɃZbg܂B
     *
     */
    private void updateManagerOperationView() {
        /*
         * OID TreeőIꂽOIDSNMP V1/V2C/V3 }l[WView
         * OID̓eLXgɃZbg
         */
        NetJFWatcherApplication.getSnmpV1OperationView().getOidText().setText(
            selectOid);
        NetJFWatcherApplication.getSnmpV2OperationView().getOidText().setText(
            selectOid);
        NetJFWatcherApplication.getSnmpV3OperationView().getOidText().setText(
            selectOid);

  
    }
}
