/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.gui.table;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;


/**
 * JMX Agentf[^e[uTableLabel/Font ProviderNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JMXMXBeanTableViewLabelProvider implements ITableLabelProvider,
    IFontProvider {

    public static final String[] HEADER_COLUMNS =
        new String[] { "MBean", "Attribute", "Value", "Type", "Access" };

    public static final int MANAGER_TABLE_ARRAY_COUNT = 5;

    public static final int BEAN_NAME_COLUMN_NO = 0;

    public static final int ATTRIBUTE_COLUMN_NO = 1;

    public static final int VALUE_COLUMN_NO = 2;

    public static final int TYPE_COLUMN_NO = 3;

    public static final int ACCESS_COLUMN_NO = 4;

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITableLabelProvider#getColumnImage(java.lang.Object, int)
     */
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITableLabelProvider#getColumnText(java.lang.Object, int)
     */
    public String getColumnText(Object element, int columnIndex) {
        String[] test = (String[]) element;

        return test[columnIndex];
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IFontProvider#getFont(java.lang.Object)
     */
    public Font getFont(Object element) {
        //assert element instanceof SyndEntryI;
        FontRegistry fr = JFaceResources.getFontRegistry();

        /* SyndEntryI   entry = (SyndEntryI) element;

        if (! HistoryManager.getInstance().isRead(entry.getLink())) {
            return fr.getBold(JFaceResources.DEFAULT_FONT);
        } */
        return fr.get(JFaceResources.DEFAULT_FONT);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
     */
    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void addListener(ILabelProviderListener listener) {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
     */
    public void dispose() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
     */
    public void removeListener(ILabelProviderListener listener) {
    }
}
