/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class JMXBeanReceiveMessageQueue {
	/* L[郊Xg */
	private static List<JMXBeanInfo> beanInfoQueueList;

	private static final int LIMIT = 10000;

	private JMXBeanReceiveMessageQueue() {
		beanInfoQueueList = Collections
				.synchronizedList(new LinkedList<JMXBeanInfo>());
	}

	public synchronized void pushBeanInfoData(final JMXBeanInfo beanInfo) {

		if (beanInfoQueueList.size() > LIMIT) {
			beanInfoQueueList.remove(0);
			beanInfoQueueList.add(beanInfo);
		} else {
			beanInfoQueueList.add(beanInfo);
		}
	}

	public synchronized JMXBeanInfo popBeanInfo() {
		JMXBeanInfo beanInfoObj = null;

		if (beanInfoQueueList.size() > 0) {
			beanInfoObj = (JMXBeanInfo) beanInfoQueueList.get(0);
			beanInfoQueueList.remove(0);
		}

		return beanInfoObj;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static JMXBeanReceiveMessageQueue getInstance() {
		return SingletonResource.BEAN_MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final JMXBeanReceiveMessageQueue BEAN_MESSAGE_QUEUE = new JMXBeanReceiveMessageQueue();
	}
}
