/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.jmx.gui.table.JMXMXBeanTableViewLabelProvider;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;


public class JMXBeanTableTimerProcessor extends AbstractTableView implements
		Runnable {

	public static final int TIMER = 1000;

	private Display display;

	private TableViewer viewer;
	private Table beanTable;

	private JMXBeanTableTimerProcessor() {
		// nothing
	}

	public void run() {
		if (beanTable != null && !beanTable.isDisposed()
				&& beanTable.getVisible()) {
			JMXBeanInfo beanInfoObj = (JMXBeanInfo) JMXBeanReceiveMessageQueue
					.getInstance().popBeanInfo();

			while (beanInfoObj != null) {
				String[] beanInfo = new String[JMXMXBeanTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];

				beanInfo[JMXMXBeanTableViewLabelProvider.BEAN_NAME_COLUMN_NO] = beanInfoObj
						.getBeanName();
				beanInfo[JMXMXBeanTableViewLabelProvider.ATTRIBUTE_COLUMN_NO] = beanInfoObj
						.getBeanAttributeName();
				beanInfo[JMXMXBeanTableViewLabelProvider.VALUE_COLUMN_NO] = beanInfoObj
						.getBeanValue();
				beanInfo[JMXMXBeanTableViewLabelProvider.TYPE_COLUMN_NO] = beanInfoObj
						.getBeanType();
				beanInfo[JMXMXBeanTableViewLabelProvider.ACCESS_COLUMN_NO] = beanInfoObj
						.getBeanAccess();

				TableItem tableItem = new TableItem(beanTable, SWT.NULL);
				tableItem.setData(beanInfo);
				tableItem.setText(beanInfo);

				// sortTable(beanTable, 0, true);
				beanInfoObj = (JMXBeanInfo) JMXBeanReceiveMessageQueue
						.getInstance().popBeanInfo();
			}
		}
		// ^C}[p
		display.timerExec(TIMER, this);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static JMXBeanTableTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	/**
	 * XVe[uZbg܂B
	 * 
	 * @param table
	 *            XVe[u
	 */
	public void setTable(TableViewer viewer, Table table) {
		this.beanTable = table;
		this.viewer = viewer;
	}

	protected void setResizedTableColumnWidth() {
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final JMXBeanTableTimerProcessor RESOURCE = new JMXBeanTableTimerProcessor();
	}

	public Table getBeanTable() {
		return beanTable;
	}

	public TableViewer getViewer() {
		return viewer;
	}
}
