/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model;

import java.io.IOException;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import netjfwatcher.jmx.model.bean.ClassLoadingMXBeanModel;
import netjfwatcher.jmx.model.bean.CompilationMXBeanModel;
import netjfwatcher.jmx.model.bean.GarbageCollectorMXBeanModel;
import netjfwatcher.jmx.model.bean.LoggingMXBeanModel;
import netjfwatcher.jmx.model.bean.MemoryMXBeanModel;
import netjfwatcher.jmx.model.bean.MemoryManagerMXBeanModel;
import netjfwatcher.jmx.model.bean.MemoryPoolMXBeanModel;
import netjfwatcher.jmx.model.bean.OperatingSystemMXBeanModel;
import netjfwatcher.jmx.model.bean.RuntimeMXBeanModel;
import netjfwatcher.jmx.model.bean.SunOperatingSystemMXBeanModel;
import netjfwatcher.jmx.model.bean.ThreadMXBeanModel;

public class JMXMXBeanCollector {

	public static final String ACCESS_RO = "RO";

	public static final String ACCESS_RW = "RW";

	public static final String TYPE_STRING = "java.lang.String";

	public static final String TYPE_INT = "int";

	public static final String TYPE_LONG = "long";

	public static final String TYPE_BOOLEAN = "boolean";

	private JMXMXBeanCollector() {

	}

	public void getMXBeanInfo(String hostName, String portNum, String beanName)
			throws java.rmi.ConnectException, java.net.ConnectException,
			MalformedObjectNameException, IOException {
		JMXServiceURL jmxURL = null;
		JMXConnector jmxConnector = null;
		MBeanServerConnection pfServer = null;
		try {
			jmxURL = new JMXServiceURL(
					"service:jmx:rmi:///jndi/rmi://" + hostName + ":" + portNum
							+ "/jmxrmi");
			jmxConnector = JMXConnectorFactory.connect(jmxURL);
			pfServer = jmxConnector.getMBeanServerConnection();

			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.OPERATING_SYSTEM_MXBEAN)) {
				OperatingSystemMXBeanModel.getInstance()
						.getOperatingSystemMXBean(pfServer);
				SunOperatingSystemMXBeanModel.getInstance()
						.getSunOperatingSystemMXBean(pfServer);
			}

			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.RUNTIME_MXBEAN)) {
				RuntimeMXBeanModel.getInstance().getRuntimeMXBean(pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.COMPILATION_MXBEAN)) {
				CompilationMXBeanModel.getInstance().getCompilationMXBean(
						pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.CLASS_LOADING_MXBEAN)) {
				ClassLoadingMXBeanModel.getInstance().getClassLoadingMXBean(
						pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.GARBAGECOLLECTOR_MXBEAN)) {

				GarbageCollectorMXBeanModel.getInstance()
						.getGarbageCollectorMXBean(pfServer);

			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.THREAD_MXBEAN)) {
				ThreadMXBeanModel.getInstance().getThreadMXBean(pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.MEMORY_MXBEAN)) {
				MemoryMXBeanModel.getInstance().getMemoryMXBean(pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.MEMORY_MANAGER_MXBEAN)) {

				MemoryManagerMXBeanModel.getInstance().getMemoryManagerMXBean(
						pfServer);

			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.MEMORY_POOL_MXBEAN)) {
				MemoryPoolMXBeanModel.getInstance().getMemoryPoolMXBean(
						pfServer);
			}
			if (beanName.equals(JMXBeanDefine.MXBEAN)
					|| beanName.equals(JMXBeanDefine.LOGGING_MXBEAN)) {
				LoggingMXBeanModel.getInstance().getLoggingMXBean(pfServer);
			}

		} catch (java.rmi.ConnectException e) {
			e.printStackTrace();
			throw e;

		} catch (java.net.ConnectException e) {
			e.printStackTrace();
			throw e;

		} catch (MalformedObjectNameException e) {
			e.printStackTrace();
			throw e;

		} catch (IOException e) {
			e.printStackTrace();
			throw e;

		} finally {
			if(jmxConnector != null) {
				jmxConnector.close();
			}
		}

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static JMXMXBeanCollector getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final JMXMXBeanCollector RESOURCE = new JMXMXBeanCollector();
	}
}
