/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class ClassLoadingMXBeanModel {

	private ClassLoadingMXBeanModel() {
		
	}
	
	public void getClassLoadingMXBean(MBeanServerConnection pfServer)
			throws IOException {
		ClassLoadingMXBean classLoadingbean = ManagementFactory
				.newPlatformMXBeanProxy(pfServer,
						ManagementFactory.CLASS_LOADING_MXBEAN_NAME,
						ClassLoadingMXBean.class);

		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.CLASS_LOADING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("TotalLoadedClassCount");
		beanInfo.setBeanValue(Long.toString(classLoadingbean
				.getTotalLoadedClassCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.CLASS_LOADING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("LoadedClassCount");
		beanInfo.setBeanValue(Long.toString(classLoadingbean
				.getLoadedClassCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.CLASS_LOADING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("UnloadedClassCount");
		beanInfo.setBeanValue(Long.toString(classLoadingbean
				.getUnloadedClassCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.CLASS_LOADING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Verbose");
		beanInfo.setBeanValue(Boolean.toString(classLoadingbean.isVerbose()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RW);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ClassLoadingMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ClassLoadingMXBeanModel RESOURCE = new ClassLoadingMXBeanModel();
	}
}
