/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class CompilationMXBeanModel {

	private CompilationMXBeanModel() {

	}

	public void getCompilationMXBean(MBeanServerConnection pfServer)
			throws IOException {
		CompilationMXBean compilationbean = ManagementFactory
				.newPlatformMXBeanProxy(pfServer,
						ManagementFactory.COMPILATION_MXBEAN_NAME,
						CompilationMXBean.class);

		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.COMPILATION_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Name");
		beanInfo.setBeanValue(compilationbean.getName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.COMPILATION_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("TotalCompilationTime");
		beanInfo.setBeanValue(Long.toString(compilationbean
				.getTotalCompilationTime()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.COMPILATION_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("CompilationTimeMonitoringSupported");
		beanInfo.setBeanValue(Boolean.toString(compilationbean
				.isCompilationTimeMonitoringSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static CompilationMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final CompilationMXBeanModel RESOURCE = new CompilationMXBeanModel();
	}
}
