/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class GarbageCollectorMXBeanModel {

	private GarbageCollectorMXBeanModel() {

	}

	public void getGarbageCollectorMXBean(MBeanServerConnection pfServer)
			throws MalformedObjectNameException, IOException {
		
		List<GarbageCollectorMXBean> gcmbeansList = new ArrayList<GarbageCollectorMXBean>();;
		ObjectName gcName = new ObjectName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE+",*");
		Set mbeansSet = pfServer.queryNames(gcName, null);
        if (mbeansSet != null) {
            Iterator iterator = mbeansSet.iterator();
            GarbageCollectorMXBean gcbean = null;
            while (iterator.hasNext()) {
                ObjectName objName = (ObjectName) iterator.next();
                gcbean = ManagementFactory.newPlatformMXBeanProxy(pfServer,
                                           objName.getCanonicalName(),
                                           GarbageCollectorMXBean.class);
                gcmbeansList.add(gcbean);
            }
        }        

		for (int i = 0; i < gcmbeansList.size(); i++) {
			GarbageCollectorMXBean gcbean = (GarbageCollectorMXBean) gcmbeansList
					.get(i);

			JMXBeanInfo beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("Name." + i);
			beanInfo.setBeanValue(gcbean.getName());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

			beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("CollectionCount." + i);
			beanInfo.setBeanValue(Long.toString(gcbean.getCollectionCount()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

			beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("CollectionTime." + i);
			beanInfo.setBeanValue(Long.toString(gcbean.getCollectionTime()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

			beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("Valid." + i);
			beanInfo.setBeanValue(Boolean.toString(gcbean.isValid()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			String[] memoryPoolName = gcbean.getMemoryPoolNames();
			for (int j = 0; j < memoryPoolName.length; j++) {
				beanInfo = new JMXBeanInfo();
				beanInfo
						.setBeanName(ManagementFactory.GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
				beanInfo.setBeanAttributeName("MemoryPoolName." + i + "." + j);
				beanInfo.setBeanValue(memoryPoolName[j]);
				beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
				beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
				JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(
						beanInfo);
			}

		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static GarbageCollectorMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final GarbageCollectorMXBeanModel RESOURCE = new GarbageCollectorMXBeanModel();
	}
}
