/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.LoggingMXBean;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;


public class LoggingMXBeanModel {

	private LoggingMXBeanModel() {
		
	}
	
	public void getLoggingMXBean(MBeanServerConnection pfServer)
	throws IOException {

		LoggingMXBean logBean = ManagementFactory.newPlatformMXBeanProxy
        (pfServer, LogManager.LOGGING_MXBEAN_NAME, LoggingMXBean.class);

		List <String>logBeanList = logBean.getLoggerNames();
		
		for(int i = 0; i < logBeanList.size(); i++) {
		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo
				.setBeanName(LogManager.LOGGING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Name." + i);
		beanInfo.setBeanValue((String)logBeanList.get(i));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo
				.setBeanName(LogManager.LOGGING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ParentLoggerName." + i);
		beanInfo.setBeanValue(logBean.getParentLoggerName((String)logBeanList.get(i)));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo
				.setBeanName(LogManager.LOGGING_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("LoggerLevel." + i);
		beanInfo.setBeanValue(logBean.getLoggerLevel((String)logBeanList.get(i)));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		}
	}
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static LoggingMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final LoggingMXBeanModel RESOURCE = new LoggingMXBeanModel();
	}
}
