/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class MemoryMXBeanModel {

	private MemoryMXBeanModel() {
		
	}
	
	
	public void getMemoryMXBean(MBeanServerConnection pfServer)
	throws IOException {
		MemoryMXBean mbean = ManagementFactory.newPlatformMXBeanProxy(
				pfServer, ManagementFactory.MEMORY_MXBEAN_NAME,
				MemoryMXBean.class);
		
		MemoryUsage memoryUsage = mbean.getHeapMemoryUsage();
		
		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("HeapMemoryUsage Init");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getInit()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("HeapMemoryUsage Max");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getMax()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("HeapMemoryUsage Used");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getUsed()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("HeapMemoryUsage Committed");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getCommitted()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		MemoryUsage nonHeapMemoryUsage = mbean.getNonHeapMemoryUsage();
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("NonHeapMemoryUsage Init");
		beanInfo.setBeanValue(Long.toString(nonHeapMemoryUsage.getInit()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("NonHeapMemoryUsage Max");
		beanInfo.setBeanValue(Long.toString(nonHeapMemoryUsage.getMax()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("NonHeapMemoryUsage Used");
		beanInfo.setBeanValue(Long.toString(nonHeapMemoryUsage.getUsed()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("NonHeapMemoryUsage Committed");
		beanInfo.setBeanValue(Long.toString(nonHeapMemoryUsage.getCommitted()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ObjectPendingFinalizationCount");
		beanInfo.setBeanValue(Integer.toString(mbean.getObjectPendingFinalizationCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_INT);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Verbose");
		beanInfo.setBeanValue(Boolean.toString(mbean.isVerbose()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
	}
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static MemoryMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final MemoryMXBeanModel RESOURCE = new MemoryMXBeanModel();
	}
}
