/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class MemoryManagerMXBeanModel {

	private MemoryManagerMXBeanModel() {

	}

	public void getMemoryManagerMXBean(MBeanServerConnection pfServer)
			throws MalformedObjectNameException, IOException {

		List<MemoryManagerMXBean> memoryManagerList = new ArrayList<MemoryManagerMXBean>();
		Set srvMemMgrNamesSet = pfServer.queryNames(new ObjectName(
		            ManagementFactory.MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE + ",*"), null);

		System.out.println("size : " + srvMemMgrNamesSet.size());
		
		if (srvMemMgrNamesSet != null) {
			Iterator iterator = srvMemMgrNamesSet.iterator();
			MemoryManagerMXBean memMgrBean = null;
			
			while (iterator.hasNext()) {
				
				Object memMgrName = (ObjectName) iterator.next();
				ObjectName memMgr = (ObjectName) memMgrName;
	            memMgrBean = 
	                ManagementFactory.newPlatformMXBeanProxy(
	                		pfServer, memMgr.toString(), MemoryManagerMXBean.class);
				memoryManagerList.add(memMgrBean);
				System.out.println(memMgr.toString());
			}
		}

		for (int j = 0; j < memoryManagerList.size(); j++) {
			MemoryManagerMXBean mmbean = (MemoryManagerMXBean) memoryManagerList
					.get(j);

			JMXBeanInfo beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("Name");
			beanInfo.setBeanValue(mmbean.getName());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

			String[] memoryPoolName = mmbean.getMemoryPoolNames();
			for (int i = 0; i < memoryPoolName.length; i++) {
				beanInfo = new JMXBeanInfo();
				beanInfo
						.setBeanName(ManagementFactory.MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE);
				beanInfo.setBeanAttributeName("MemoryPoolName." + i);
				beanInfo.setBeanValue(memoryPoolName[i]);
				beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
				beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			}
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static MemoryManagerMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final MemoryManagerMXBeanModel RESOURCE = new MemoryManagerMXBeanModel();
	}
}
