/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class MemoryPoolMXBeanModel {

	private MemoryPoolMXBeanModel() {

	}

	public void getMemoryPoolMXBean(MBeanServerConnection pfServer)
			throws IOException {
		MemoryPoolMXBean mpbean = ManagementFactory.newPlatformMXBeanProxy(
				pfServer, ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE
						+ ",name=Tenured Gen", MemoryPoolMXBean.class);

		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("Name");
		beanInfo.setBeanValue(mpbean.getName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("Type");
		beanInfo.setBeanValue(mpbean.getType().toString());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("Valid");
		beanInfo.setBeanValue(Boolean.toString(mpbean.isValid()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		String[] memoryManager = mpbean.getMemoryManagerNames();
		for (int i = 0; i < memoryManager.length; i++) {
			beanInfo = new JMXBeanInfo();
			beanInfo
					.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
			beanInfo.setBeanAttributeName("MemoryManagerName");
			beanInfo.setBeanValue(memoryManager[i]);
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		}
		MemoryUsage memoryUsage = mpbean.getUsage();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("MemoryUsage Init");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getInit()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("MemoryUsage Max");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getMax()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("MemoryUsage Used");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getUsed()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("MemoryUsage Committed");
		beanInfo.setBeanValue(Long.toString(memoryUsage.getCommitted()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		MemoryUsage peakUsage = mpbean.getPeakUsage();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("PeakUsage Init");
		beanInfo.setBeanValue(Long.toString(peakUsage.getInit()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("PeakUsage Max");
		beanInfo.setBeanValue(Long.toString(peakUsage.getMax()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("PeakUsage Used");
		beanInfo.setBeanValue(Long.toString(peakUsage.getUsed()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("PeakUsage Committed");
		beanInfo.setBeanValue(Long.toString(peakUsage.getCommitted()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		MemoryUsage collectionUsage = mpbean.getCollectionUsage();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsage Init");
		beanInfo.setBeanValue(Long.toString(collectionUsage.getInit()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsage Max");
		beanInfo.setBeanValue(Long.toString(collectionUsage.getMax()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsage Used");
		beanInfo.setBeanValue(Long.toString(collectionUsage.getUsed()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsage Committed");
		beanInfo.setBeanValue(Long.toString(collectionUsage.getCommitted()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("UsageThreshold");
		beanInfo.setBeanValue(Long.toString(mpbean.getUsageThreshold()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("UsageThresholdSupported");
		beanInfo.setBeanValue(Boolean.toString(mpbean
				.isUsageThresholdSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("UsageThresholdExceeded");
		beanInfo.setBeanValue(Boolean.toString(mpbean
				.isUsageThresholdExceeded()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("UsageThresholdCount");
		beanInfo.setBeanValue(Long.toString(mpbean.getUsageThresholdCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsageThreshold");
		beanInfo.setBeanValue(Long.toString(mpbean
				.getCollectionUsageThreshold()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsageThresholdSupported");
		beanInfo.setBeanValue(Boolean.toString(mpbean
				.isCollectionUsageThresholdSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsageThresholdExceeded");
		beanInfo.setBeanValue(Boolean.toString(mpbean
				.isCollectionUsageThresholdExceeded()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
		beanInfo.setBeanAttributeName("CollectionUsageThresholdCount");
		beanInfo.setBeanValue(Long.toString(mpbean
				.getCollectionUsageThresholdCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static MemoryPoolMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final MemoryPoolMXBeanModel RESOURCE = new MemoryPoolMXBeanModel();
	}

}
