/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class OperatingSystemMXBeanModel {

	private OperatingSystemMXBeanModel() {

	}

	public void getOperatingSystemMXBean(MBeanServerConnection pfServer)
			throws IOException {

		OperatingSystemMXBean osbean = ManagementFactory
				.newPlatformMXBeanProxy(pfServer,
						ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME,
						OperatingSystemMXBean.class);

		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Arch");
		beanInfo.setBeanValue(osbean.getArch());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Name");
		beanInfo.setBeanValue(osbean.getName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Version");
		beanInfo.setBeanValue(osbean.getVersion());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static OperatingSystemMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final OperatingSystemMXBeanModel RESOURCE = new OperatingSystemMXBeanModel();
	}
}
