/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class RuntimeMXBeanModel {

	/* tH[}bg */
	private final DateFormat simpleDateformat = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");
	
	private RuntimeMXBeanModel() {

	}

	public void getRuntimeMXBean(MBeanServerConnection pfServer)
			throws IOException {
		RuntimeMXBean rtbean = ManagementFactory.newPlatformMXBeanProxy(
				pfServer, ManagementFactory.RUNTIME_MXBEAN_NAME,
				RuntimeMXBean.class);
		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Name");
		beanInfo.setBeanValue(rtbean.getName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("SpecName");
		beanInfo.setBeanValue(rtbean.getSpecName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("SpecVendor");
		beanInfo.setBeanValue(rtbean.getSpecVendor());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("SpecVersion");
		beanInfo.setBeanValue(rtbean.getSpecVersion());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("VmName");
		beanInfo.setBeanValue(rtbean.getVmName());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("VmVendor");
		beanInfo.setBeanValue(rtbean.getVmVendor());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("VmVersion");
		beanInfo.setBeanValue(rtbean.getVmVersion());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("StartTime");
		Date date = Calendar.getInstance().getTime();
		date.setTime(rtbean.getStartTime());
		beanInfo.setBeanValue(simpleDateformat.format(date) + "("
				+ Long.toString(rtbean.getStartTime()) + ")");
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("Uptime");
		beanInfo.setBeanValue(getTimeSting(rtbean.getUptime()) + " ("
				+ Long.toString(rtbean.getUptime()) + ")");
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ClassPath");
		beanInfo.setBeanValue(rtbean.getClassPath());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("BootClassPath");
		beanInfo.setBeanValue(rtbean.getBootClassPath());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("LibraryPath");
		beanInfo.setBeanValue(rtbean.getLibraryPath());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);

		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.RUNTIME_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ManagementSpecVersion");
		beanInfo.setBeanValue(rtbean.getManagementSpecVersion());
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
	}

	private String getTimeSting(long time) {
		int ms;
		int second;
		int minute;
		int hour;
		int day;

		int baseUnit = 1000;

		ms = (int) (time % baseUnit);
		second = (int) ((time / baseUnit) % 60);
		minute = (int) ((time / baseUnit / 60) % 60);
		hour = (int) ((time / baseUnit / 60 / 60) % 24);
		day = (int) (time / baseUnit / 60 / 60 / 24);

		String timeData = day + "day  " + hour + "hour  " + minute + "min  "
				+ second + "sec  " + ms + "msec";

		return timeData;
	}
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static RuntimeMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final RuntimeMXBeanModel RESOURCE = new RuntimeMXBeanModel();
	}
}
