/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;

import javax.management.MBeanServerConnection;
import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class SunOperatingSystemMXBeanModel {

	private SunOperatingSystemMXBeanModel() {

	}

	public void getSunOperatingSystemMXBean(MBeanServerConnection pfServer)
			throws IOException {
		com.sun.management.OperatingSystemMXBean sunOsbean = ManagementFactory
				.newPlatformMXBeanProxy(pfServer,
						ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME,
						com.sun.management.OperatingSystemMXBean.class);
		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("TotalPhysicalMemorySize");
		beanInfo.setBeanValue(Long.toString(sunOsbean
				.getTotalPhysicalMemorySize()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("FreePhysicalMemorySize");
		beanInfo.setBeanValue(Long.toString(sunOsbean
				.getFreePhysicalMemorySize()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("TotalSwapSpaceSize");
		beanInfo.setBeanValue(Long.toString(sunOsbean.getTotalSwapSpaceSize()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("FreeSwapSpaceSize");
		beanInfo.setBeanValue(Long.toString(sunOsbean.getFreeSwapSpaceSize()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("CommittedVirtualMemorySize");
		beanInfo.setBeanValue(Long.toString(sunOsbean
				.getCommittedVirtualMemorySize()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.OPERATING_SYSTEM_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ProcessCpuTime");
		beanInfo.setBeanValue(Long.toString(sunOsbean.getProcessCpuTime()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SunOperatingSystemMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SunOperatingSystemMXBeanModel RESOURCE = new SunOperatingSystemMXBeanModel();
	}
}
