/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.model.bean;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

import javax.management.MBeanServerConnection;

import netjfwatcher.jmx.model.JMXBeanInfo;
import netjfwatcher.jmx.model.JMXBeanReceiveMessageQueue;
import netjfwatcher.jmx.model.JMXMXBeanCollector;

public class ThreadMXBeanModel {

	private ThreadMXBeanModel() {
		
	}

	public void getThreadMXBean(MBeanServerConnection pfServer)
	throws IOException {
		ThreadMXBean threadbean = ManagementFactory.newPlatformMXBeanProxy(
				pfServer, ManagementFactory.THREAD_MXBEAN_NAME,
				ThreadMXBean.class);
		
		
		JMXBeanInfo beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ThreadCount");
		beanInfo.setBeanValue(Long.toString(threadbean.getThreadCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("DaemonThreadCount");
		beanInfo.setBeanValue(Long.toString(threadbean.getDaemonThreadCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("PeakThreadCount");
		beanInfo.setBeanValue(Long.toString(threadbean.getPeakThreadCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("TotalStartedThreadCount");
		beanInfo.setBeanValue(Long.toString(threadbean.getTotalStartedThreadCount()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("CurrentThreadCpuTime");
		beanInfo.setBeanValue(Long.toString(threadbean.getCurrentThreadCpuTime()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("CurrentThreadCpuTimeSupported");
		beanInfo.setBeanValue(Boolean.toString(threadbean.isCurrentThreadCpuTimeSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ThreadCpuTimeEnabled");
		beanInfo.setBeanValue(Boolean.toString(threadbean.isThreadCpuTimeEnabled()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RW);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ThreadCpuTimeSupported");
		beanInfo.setBeanValue(Boolean.toString(threadbean.isThreadCpuTimeSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("CurrentThreadUserTime");
		beanInfo.setBeanValue(Long.toString(threadbean.getCurrentThreadUserTime()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ThreadContentionMonitoringEnabled");
		beanInfo.setBeanValue(Boolean.toString(threadbean.isThreadContentionMonitoringEnabled()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RW);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		beanInfo = new JMXBeanInfo();
		beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
		beanInfo.setBeanAttributeName("ThreadContentionMonitoringSupported");
		beanInfo.setBeanValue(Boolean.toString(threadbean.isThreadContentionMonitoringSupported()));
		beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
		beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
		JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		
		long [] ids = threadbean.getAllThreadIds();
		for(int i = 0; i < ids.length; i++) {
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("ThreadUserTime." + i);
			beanInfo.setBeanValue(Long.toString(threadbean.getThreadUserTime(ids[i])));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("ThreadCpuTime." + i);
			beanInfo.setBeanValue(Long.toString(threadbean.getThreadCpuTime(ids[i])));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			ThreadInfo threadInfo = threadbean.getThreadInfo(ids[i]);
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("ThreadId." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getThreadId()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("ThreadName." + i);
			beanInfo.setBeanValue(threadInfo.getThreadName());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("ThreadState." + i);
			beanInfo.setBeanValue(threadInfo.getThreadState().toString());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("Suspended." + i);
			beanInfo.setBeanValue(Boolean.toString(threadInfo.isSuspended()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("InNative." + i);
			beanInfo.setBeanValue(Boolean.toString(threadInfo.isInNative()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_BOOLEAN);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("BlockedTime." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getBlockedTime()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("BlockedCount." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getBlockedCount()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("WaitedTime." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getWaitedTime()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("WaitedCount." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getWaitedCount()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("LockName." + i);
			beanInfo.setBeanValue(threadInfo.getLockName());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("LockOwnerId." + i);
			beanInfo.setBeanValue(Long.toString(threadInfo.getLockOwnerId()));
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_LONG);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
			
			beanInfo = new JMXBeanInfo();
			beanInfo.setBeanName(ManagementFactory.THREAD_MXBEAN_NAME);
			beanInfo.setBeanAttributeName("LockOwnerName." + i);
			beanInfo.setBeanValue(threadInfo.getLockOwnerName());
			beanInfo.setBeanType(JMXMXBeanCollector.TYPE_STRING);
			beanInfo.setBeanAccess(JMXMXBeanCollector.ACCESS_RO);
			JMXBeanReceiveMessageQueue.getInstance().pushBeanInfoData(beanInfo);
		}
	}
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ThreadMXBeanModel getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ThreadMXBeanModel RESOURCE = new ThreadMXBeanModel();
	}
}
