/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.perspective;

import netjfwatcher.jmx.gui.JMXBeanMenuView;
import netjfwatcher.jmx.gui.JMXBeanOperationView;
import netjfwatcher.jmx.gui.table.JMXMXBeanTableView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


public class JMXRemotePerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.jmx.perspective.JMXRemotePerspective";
    private static final float BEAN_TREE_VIEW_RATIO = 0.25f;
    private static final float BEAN_TABLE_VIEW_RATIO = 0.55f;
    private static final float BEAN_OPERATION_VIEW_RATIO = 0.40f;

    /**
     * CAEg̏ݒs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* Bean Treer[ */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, BEAN_TREE_VIEW_RATIO, editorArea);
        left.addView(JMXBeanMenuView.class.getName());

        /* JMX Beanr[ */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.BOTTOM, BEAN_OPERATION_VIEW_RATIO, editorArea);
        top.addView(JMXBeanOperationView.class.getName());


        /* JMX Bean Mf[^ATrapMf[^\ */
        IFolderLayout bottom =
            layout.createFolder(
                "bottom", IPageLayout.BOTTOM, BEAN_TABLE_VIEW_RATIO,
                editorArea);
        bottom.addView(JMXMXBeanTableView.class.getName());

    }
}
