/*
 * Created on 2007/03/06
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.jmx.perspective;

import netjfwatcher.jmx.gui.snmp.JMXSnmpOIDTreeView;
import netjfwatcher.snmpmanager.OidTableView;
import netjfwatcher.snmpmanager.SnmpV1OperationView;
import netjfwatcher.snmpmanager.SnmpV2OperationView;
import netjfwatcher.snmpmanager.SnmpV3OperationView;
import netjfwatcher.snmpmanager.TrapReceiveTableView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


public class JMXSnmpPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.jmx.perspective.JMXSnmpPerspective";
    private static final float OID_TREE_VIEW_RATIO = 0.25f;
    private static final float AGENT_RECEIVE_VIEW_RATIO = 0.55f;
    private static final float SNMP_OPERATION_VIEW_RATIO = 0.40f;

    /**
     * CAEg̏ݒs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* OID Treer[ */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, OID_TREE_VIEW_RATIO, editorArea);
        left.addView(JMXSnmpOIDTreeView.class.getName());

        /* Snmp V1/V2/V3r[ */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.BOTTOM, SNMP_OPERATION_VIEW_RATIO, editorArea);
        top.addView(SnmpV1OperationView.class.getName());
        top.addView(SnmpV2OperationView.class.getName());
        top.addView(SnmpV3OperationView.class.getName());

        /* SnmpG[WFg牞Mf[^ATrapMf[^\ */
        IFolderLayout bottom =
            layout.createFolder(
                "bottom", IPageLayout.BOTTOM, AGENT_RECEIVE_VIEW_RATIO,
                editorArea);
        bottom.addView(OidTableView.class.getName());
        bottom.addView(TrapReceiveTableView.class.getName());
    }
}
