/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXAConnection;
import org.apache.derby.jdbc.ClientDataSource;

public class ClientPooledConnection
implements PooledConnection {
    private boolean newPC_ = true;
    private Vector listeners_ = null;
    Connection physicalConnection_ = null;
    NetConnection netPhysicalConnection_ = null;
    NetXAConnection netXAPhysicalConnection_ = null;
    LogicalConnection logicalConnection_ = null;
    protected LogWriter logWriter_ = null;
    protected int rmId_ = 0;
    private ClientDataSource ds_;
    private String user_;
    private String password_;

    public ClientPooledConnection(ClientDataSource clientDataSource, LogWriter logWriter, String string, String string2) throws SqlException {
        this.logWriter_ = logWriter;
        this.ds_ = clientDataSource;
        this.user_ = string;
        this.password_ = string2;
        this.listeners_ = new Vector();
        this.netPhysicalConnection_ = new NetConnection((NetLogWriter)this.logWriter_, string, string2, clientDataSource, -1, false);
        this.physicalConnection_ = this.netPhysicalConnection_;
    }

    public ClientPooledConnection(ClientDataSource clientDataSource, LogWriter logWriter, String string, String string2, int n) throws SqlException {
        this.logWriter_ = logWriter;
        this.ds_ = clientDataSource;
        this.user_ = string;
        this.password_ = string2;
        this.rmId_ = n;
        this.listeners_ = new Vector();
        this.netXAPhysicalConnection_ = new NetXAConnection((NetLogWriter)this.logWriter_, string, string2, clientDataSource, n, true);
        this.physicalConnection_ = this.netXAPhysicalConnection_;
    }

    public ClientPooledConnection(ClientDataSource clientDataSource, LogWriter logWriter) throws SqlException {
        this.logWriter_ = logWriter;
        this.ds_ = clientDataSource;
        this.listeners_ = new Vector();
        this.netPhysicalConnection_ = new NetConnection((NetLogWriter)this.logWriter_, null, null, clientDataSource, -1, false);
        this.physicalConnection_ = this.netPhysicalConnection_;
    }

    protected void finalize() throws Throwable {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "finalize");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SqlException {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "close");
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.nullPhysicalConnection();
            this.logicalConnection_ = null;
        }
        if (this.physicalConnection_ == null) {
            return;
        }
        try {
            this.physicalConnection_.closeResources();
        }
        finally {
            this.physicalConnection_ = null;
        }
    }

    public synchronized java.sql.Connection getConnection() throws SqlException {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "getConnection");
        }
        this.createLogicalConnection();
        if (!this.newPC_) {
            this.physicalConnection_.reset(this.logWriter_, this.user_, this.password_, this.ds_, false);
        } else {
            this.physicalConnection_.lightReset();
        }
        this.newPC_ = false;
        if (this.logWriter_ != null) {
            this.logWriter_.traceExit((Object)this, "getConnection", this.logicalConnection_);
        }
        return this.logicalConnection_;
    }

    private void createLogicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(this.logWriter_, "getConnection() is not valid on a closed PooledConnection.");
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.closeWithoutRecyclingToPool();
        }
        this.logicalConnection_ = new LogicalConnection(this.physicalConnection_, this);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "addConnectionEventListener", connectionEventListener);
        }
        this.listeners_.addElement(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry((Object)this, "removeConnectionEventListener", connectionEventListener);
        }
        this.listeners_.removeElement(connectionEventListener);
    }

    public void recycleConnection() {
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "recycleConnection");
        }
        Enumeration enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    public void trashConnection(SqlException sqlException) {
        Enumeration enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public synchronized void nullLogicalConnection() {
        this.logicalConnection_ = null;
    }
}

