/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.Arc;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.Ellipse;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.Rectangle;
import org.apache.tools.ant.types.optional.image.Text;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Draw
extends TransformOperation {
    protected int xloc = 0;
    protected int yloc = 0;

    public void setXloc(int x) {
        this.xloc = x;
    }

    public void setYloc(int y) {
        this.yloc = y;
    }

    public void addRectangle(Rectangle rect) {
        this.instructions.add(rect);
    }

    public void addText(Text text) {
        this.instructions.add(text);
    }

    public void addEllipse(Ellipse elip) {
        this.instructions.add(elip);
    }

    public void addArc(Arc arc) {
        this.instructions.add(arc);
    }

    public PlanarImage executeTransformOperation(PlanarImage image) {
        BufferedImage bi = image.getAsBufferedImage();
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        int i = 0;
        while (i < this.instructions.size()) {
            PlanarImage op;
            ImageOperation instr = (ImageOperation)((Object)this.instructions.elementAt(i));
            if (instr instanceof DrawOperation) {
                op = ((DrawOperation)((Object)instr)).executeDrawOperation();
                this.log("\tDrawing to x=" + this.xloc + " y=" + this.yloc);
                graphics.drawImage(op.getAsBufferedImage(), null, this.xloc, this.yloc);
            } else if (instr instanceof TransformOperation) {
                op = ((TransformOperation)instr).executeTransformOperation(null);
                BufferedImage child = op.getAsBufferedImage();
                this.log("\tDrawing to x=" + this.xloc + " y=" + this.yloc);
                graphics.drawImage(child, null, this.xloc, this.yloc);
                PlanarImage.wrapRenderedImage((RenderedImage)bi);
            }
            ++i;
        }
        image = PlanarImage.wrapRenderedImage((RenderedImage)bi);
        return image;
    }
}

