/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.observable;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.internal.databinding.internal.IdentityWrapper;
import org.eclipse.jface.internal.databinding.internal.observable.IStalenessConsumer;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;

public class StalenessTracker {
    private Map staleMap = new HashMap();
    private int staleCount = 0;
    private final IStalenessConsumer stalenessConsumer;
    private ChildListener childListener = new ChildListener();

    public StalenessTracker(IObservable[] observables, IStalenessConsumer stalenessConsumer) {
        this.stalenessConsumer = stalenessConsumer;
        int i = 0;
        while (i < observables.length) {
            IObservable observable = observables[i];
            this.doAddObservable(observable, false);
            ++i;
        }
        stalenessConsumer.setStale(this.staleCount > 0);
    }

    public void processStalenessChange(IObservable child, boolean callback) {
        boolean newStale;
        boolean newChildStale;
        boolean oldStale = this.staleCount > 0;
        IdentityWrapper wrappedChild = new IdentityWrapper(child);
        boolean oldChildStale = this.getOldChildStale(wrappedChild);
        if (oldChildStale != (newChildStale = child.isStale())) {
            this.staleCount = oldChildStale ? --this.staleCount : ++this.staleCount;
            this.staleMap.put(wrappedChild, new Boolean(newChildStale));
        }
        boolean bl = newStale = this.staleCount > 0;
        if (callback && newStale != oldStale) {
            this.stalenessConsumer.setStale(newStale);
        }
    }

    private boolean getOldChildStale(IdentityWrapper wrappedChild) {
        Object oldChildValue = this.staleMap.get(wrappedChild);
        boolean oldChildStale = oldChildValue == null ? false : (Boolean)oldChildValue;
        return oldChildStale;
    }

    public void addObservable(IObservable observable) {
        this.doAddObservable(observable, true);
    }

    private void doAddObservable(IObservable observable, boolean callback) {
        this.processStalenessChange(observable, callback);
        observable.addChangeListener(this.childListener);
        observable.addStaleListener(this.childListener);
    }

    public void removeObservable(IObservable observable) {
        boolean newStale;
        boolean oldStale = this.staleCount > 0;
        IdentityWrapper wrappedChild = new IdentityWrapper(observable);
        boolean oldChildStale = this.getOldChildStale(wrappedChild);
        if (oldChildStale) {
            --this.staleCount;
        }
        this.staleMap.remove(wrappedChild);
        observable.removeChangeListener(this.childListener);
        observable.removeStaleListener(this.childListener);
        boolean bl = newStale = this.staleCount > 0;
        if (newStale != oldStale) {
            this.stalenessConsumer.setStale(newStale);
        }
    }

    private class ChildListener
    implements IStaleListener,
    IChangeListener {
        private ChildListener() {
        }

        public void handleStale(IObservable source) {
            StalenessTracker.this.processStalenessChange(source, true);
        }

        public void handleChange(IObservable source) {
            StalenessTracker.this.processStalenessChange(source, true);
        }
    }
}

