/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

public class ComboObservableValue
extends AbstractObservableValue {
    private final Combo combo;
    private final String attribute;
    private boolean updating = false;
    private String currentValue;
    static /* synthetic */ Class class$0;

    public ComboObservableValue(Combo combo, String attribute) {
        this.combo = combo;
        this.attribute = attribute;
        if (!attribute.equals("selection") && !attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        this.currentValue = combo.getText();
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ComboObservableValue.this.updating) {
                    String oldValue = ComboObservableValue.this.currentValue;
                    ComboObservableValue.this.currentValue = ComboObservableValue.this.combo.getText();
                    ComboObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, ComboObservableValue.this.currentValue));
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object value) {
        String oldValue = this.combo.getText();
        try {
            this.updating = true;
            if (this.attribute.equals("text")) {
                String stringValue = value != null ? value.toString() : "";
                this.combo.setText(stringValue);
            } else if (this.attribute.equals("selection")) {
                String[] items = this.combo.getItems();
                int index = -1;
                if (items != null && value != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (value.equals(items[i])) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        this.combo.setText((String)value);
                    } else {
                        this.combo.select(index);
                    }
                }
            }
            Object var6_9 = null;
            this.updating = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.updating = false;
            throw throwable;
        }
        this.fireValueChange(Diffs.createValueDiff(oldValue, this.combo.getText()));
    }

    public Object doGetValue() {
        if (this.attribute.equals("text")) {
            return this.combo.getText();
        }
        Assert.isTrue((boolean)this.attribute.equals("selection"), (String)("unexpected attribute: " + this.attribute));
        return this.combo.getText();
    }

    public Object getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute: " + this.attribute));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

