/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.viewers;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class StructuredViewerObservableValue
extends AbstractObservableValue {
    private final StructuredViewer viewer;
    private final String attribute;
    private boolean updating = false;
    private Object currentSelection;
    static /* synthetic */ Class class$0;

    public StructuredViewerObservableValue(StructuredViewer viewer, String attribute) {
        this.viewer = viewer;
        this.attribute = attribute;
        this.currentSelection = this.doGetValue();
        if (!attribute.equals("single_selection")) {
            throw new IllegalArgumentException("Attribute name not valid: " + attribute);
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!StructuredViewerObservableValue.this.updating) {
                    Object oldSelection = StructuredViewerObservableValue.this.currentSelection;
                    StructuredViewerObservableValue.this.currentSelection = StructuredViewerObservableValue.this.doGetValue();
                    StructuredViewerObservableValue.this.fireValueChange(Diffs.createValueDiff(oldSelection, StructuredViewerObservableValue.this.currentSelection));
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object value) {
        try {
            this.updating = true;
            if (this.attribute.equals("single_selection")) {
                Object oldSelection = this.currentSelection;
                this.viewer.setSelection((ISelection)(value == null ? StructuredSelection.EMPTY : new StructuredSelection(value)));
                this.currentSelection = this.doGetValue();
                this.fireValueChange(Diffs.createValueDiff(oldSelection, this.currentSelection));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.updating = false;
            return;
        }
    }

    public Object doGetValue() {
        ISelection selection;
        if (this.attribute.equals("single_selection") && (selection = this.viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            return sel.getFirstElement();
        }
        return null;
    }

    public Object getValueType() {
        Assert.isTrue((boolean)this.attribute.equals("single_selection"), (String)("unexpected attribute: " + this.attribute));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

