/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;

public final class DBTableGarbageCollection
extends DBTableBase {
    public static final String GARBAGECOLLECTION_TABLE = "garbageCollection_table";
    public static final String ID = "id";
    public static final String TOTAL_MEMORY = "total_memory";
    public static final String FREE_MEMORY = "free_memory";
    public static final String CHECK_DATE = "check_date";
    private static Logger logger = null;
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableGarbageCollection() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableGarbageCollection getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            this.deleteTable(databaseAccess, GARBAGECOLLECTION_TABLE);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropGarbageCollectionSequenceSQL());
            databaseAccess.executeUpdate(dataaccessobject.getCreateGarbageCollectionTableSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, GARBAGECOLLECTION_TABLE);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void put(String totalMemory, String freeMemory) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Date date = Calendar.getInstance().getTime();
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                databaseAccess.executeUpdate("insert into garbageCollection_table( total_memory, free_memory, check_date ) VALUES( " + totalMemory + "," + freeMemory + "," + " '" + this.simpleDateformat.format(date) + "'" + ")");
            } else {
                databaseAccess.executeUpdate("insert into garbageCollection_table( total_memory, free_memory, check_date ) VALUES( '" + totalMemory + "'," + "'" + freeMemory + "'," + " '" + this.simpleDateformat.format(date) + "'" + ")");
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized ArrayList findAll(String startTime, String endTime) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<GarbageCollectionInfo> garbageCollectionInfoList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                String sql = startTime == null || endTime == null ? "SELECT * from garbageCollection_table order by check_date desc" : "SELECT * from garbageCollection_table where check_date between '" + startTime + "'" + " and " + "'" + endTime + "'" + " order by " + CHECK_DATE + " desc";
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                garbageCollectionInfoList = new ArrayList<GarbageCollectionInfo>();
                while (rs.next()) {
                    GarbageCollectionInfo garbageCollectionInfo = new GarbageCollectionInfo();
                    garbageCollectionInfo.setCheckDate((Date)rs.getObject(CHECK_DATE));
                    garbageCollectionInfo.setTotalMemory(Long.parseLong(rs.getObject(TOTAL_MEMORY).toString()));
                    garbageCollectionInfo.setFreeMemory(Long.parseLong(rs.getObject(FREE_MEMORY).toString()));
                    garbageCollectionInfo.setCheckId(Long.parseLong(rs.getObject(ID).toString()));
                    garbageCollectionInfoList.add(garbageCollectionInfo);
                }
            }
            catch (DatabaseConnectionException ex) {
                logger.warning(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                logger.warning(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return garbageCollectionInfoList;
    }

    public synchronized GarbageCollectionControl getDataCount() throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        GarbageCollectionControl garProperty = new GarbageCollectionControl();
        try {
            String sql = "select count(*) from garbageCollection_table";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            long count = -1L;
            count = rs.getInt(1);
            garProperty.setTotalDataCount(count);
            sql = "select min(free_memory), max(free_memory), min(total_memory), max(total_memory) from garbageCollection_table";
            rs = stmt.executeQuery(sql);
            rs.next();
            long freeMemoryMin = -1L;
            freeMemoryMin = rs.getLong(1);
            long freeMemoryMax = -1L;
            freeMemoryMax = rs.getLong(2);
            garProperty.setFreeMemoryMinData(freeMemoryMin);
            garProperty.setFreeMemoryMaxData(freeMemoryMax);
            long totalMemoryMin = -1L;
            totalMemoryMin = rs.getLong(3);
            long totalMemoryMax = -1L;
            totalMemoryMax = rs.getLong(4);
            garProperty.setTotalMemoryMinData(totalMemoryMin);
            garProperty.setTotalMemoryMaxData(totalMemoryMax);
            sql = "select min(check_date), max(check_date) from garbageCollection_table";
            rs = stmt.executeQuery(sql);
            rs.next();
            garProperty.setStartDate((Date)rs.getObject(1));
            garProperty.setEndDate((Date)rs.getObject(2));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return garProperty;
    }

    /* synthetic */ DBTableGarbageCollection(DBTableGarbageCollection dBTableGarbageCollection) {
        this();
    }

    private static class SingletonResource {
        static final DBTableGarbageCollection RESOURCE = new DBTableGarbageCollection(null);

        private SingletonResource() {
        }
    }
}

