/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.socket.info.NetworkCameraInfo;

public final class DBTableNetworkCamera
extends DBTableBase {
    public static final String CAMERA_TABLE_NAME = "network_camera";
    public static final String IPADDRESS = "ipAddress";
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String REFRESH_PERIOD = "refreshPeriod";
    public static final String CONTROL_URL = "controlURL";
    public static final String JPEG_URL = "jpegURL";
    public static final String CAMERA_CURDATE = "curdate";
    private static Logger logger = null;
    private static final String CAMERA_TABLE_ITEM = " (userName VARCHAR(255), password  VARCHAR(255),refreshPeriod VARCHAR(255),controlURL VARCHAR(255),jpegURL VARCHAR(255),ipAddress VARCHAR(255),curdate TIMESTAMP )";
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableNetworkCamera() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, CAMERA_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE network_camera (userName VARCHAR(255), password  VARCHAR(255),refreshPeriod VARCHAR(255),controlURL VARCHAR(255),jpegURL VARCHAR(255),ipAddress VARCHAR(255),curdate TIMESTAMP )");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, CAMERA_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized NetworkCameraInfo findCamera(String tragetIpAddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        NetworkCameraInfo networkCameraInfo = null;
        try {
            String sql = "SELECT * from network_camera where ipAddress='" + tragetIpAddress + "'";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                networkCameraInfo = new NetworkCameraInfo();
                networkCameraInfo.setIpaddress(rs.getObject(IPADDRESS).toString());
                networkCameraInfo.setUserName(rs.getObject(USERNAME).toString());
                networkCameraInfo.setPassword(rs.getObject(PASSWORD).toString());
                networkCameraInfo.setRefreshPeriod(rs.getObject(REFRESH_PERIOD).toString());
                networkCameraInfo.setControlURL(rs.getObject(CONTROL_URL).toString());
                networkCameraInfo.setJpegURL(rs.getObject(JPEG_URL).toString());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
        return networkCameraInfo;
    }

    public synchronized void putCamera(String tragetIpAddress, NetworkCameraInfo networkCameraInfo) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {
            try {
                if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                    sql = "insert into network_camera( ipAddress, userName, password, refreshPeriod, controlURL, jpegURL, curdate ) VALUES( '" + networkCameraInfo.getIpaddress() + "'," + "'" + networkCameraInfo.getUserName() + "'," + "'" + networkCameraInfo.getPassword() + "'," + "'" + networkCameraInfo.getRefreshPeriod() + "'," + "'" + networkCameraInfo.getControlURL() + "'," + "'" + networkCameraInfo.getJpegURL() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                } else {
                    sql = "insert into network_camera( ipAddress, userName, password, refreshPeriod, controlURL, jpegURL, curdate ) VALUES( '" + networkCameraInfo.getIpaddress() + "'," + "'" + networkCameraInfo.getUserName() + "'," + "'" + networkCameraInfo.getPassword() + "'," + "'" + networkCameraInfo.getRefreshPeriod() + "'," + "'" + networkCameraInfo.getControlURL() + "'," + "'" + networkCameraInfo.getJpegURL() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                }
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw ex;
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void updateCamera(String tragetIpAddress, NetworkCameraInfo networkCameraInfo) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                this.updateCameraTabel(databaseAccess, networkCameraInfo);
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress);
                ex.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private void updateCameraTabel(DatabaseAccess databaseAccess, NetworkCameraInfo networkCameraInfo) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
            databaseAccess.executeUpdate("UPDATE network_camera set ipAddress='" + networkCameraInfo.getIpaddress() + "', " + USERNAME + "='" + networkCameraInfo.getUserName() + "', " + PASSWORD + "='" + networkCameraInfo.getPassword() + "', " + REFRESH_PERIOD + "='" + networkCameraInfo.getRefreshPeriod() + "', " + CONTROL_URL + "='" + networkCameraInfo.getControlURL() + "', " + JPEG_URL + "='" + networkCameraInfo.getJpegURL() + "', " + CAMERA_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IPADDRESS + "=" + "'" + networkCameraInfo.getIpaddress() + "'" + " ");
        } else {
            databaseAccess.executeUpdate("UPDATE network_camera set ipAddress='" + networkCameraInfo.getIpaddress() + "', " + USERNAME + "='" + networkCameraInfo.getUserName() + "', " + PASSWORD + "='" + networkCameraInfo.getPassword() + "', " + REFRESH_PERIOD + "='" + networkCameraInfo.getRefreshPeriod() + "', " + CONTROL_URL + "='" + networkCameraInfo.getControlURL() + "', " + JPEG_URL + "='" + networkCameraInfo.getJpegURL() + "', " + CAMERA_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + IPADDRESS + "=" + "'" + networkCameraInfo.getIpaddress() + "'" + " ");
        }
    }

    public synchronized void deleteCameraNodeIP(String tragetIpAddress) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "";
            sql = "DELETE from network_camera where ipAddress='" + tragetIpAddress + "'";
            databaseAccess.executeUpdate(sql);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public static DBTableNetworkCamera getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ DBTableNetworkCamera(DBTableNetworkCamera dBTableNetworkCamera) {
        this();
    }

    private static class SingletonResource {
        static final DBTableNetworkCamera RESOURCE = new DBTableNetworkCamera(null);

        private SingletonResource() {
        }
    }
}

