/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.engine.calendar.DataFilterInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class CalendarView
extends ViewPart {
    private static final int TEXT_WIDTH = 80;
    private static final int HORIZONTALSPAN6 = 6;
    private static final int HORIZONTALSPAN3 = 3;
    private static Logger logger;
    private String startDateString;
    private String endDateString;
    private int limit;
    private Button setButton;
    private Button resetButton;
    private Text limitText;
    private Text alarmStartYearText;
    private Text alarmStartMonthText;
    private Text alarmStartDateText;
    private Text alarmEndYearText;
    private Text alarmEndMonthText;
    private Text alarmEndDateText;
    private Combo startHourCombo;
    private Combo startMinuteCombo;
    private Combo endHourCombo;
    private Combo endMinuteCombo;
    private DateFormat dateformat;
    private CalendarComposite calendarComposite;

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite composite0 = new Composite(parent, 16384);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, 16384);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData());
        this.setButton = new Button(composite1, 0);
        this.setButton.setText(" Set ");
        this.setButton.setLayoutData((Object)new GridData());
        this.resetButton = new Button(composite1, 0);
        this.resetButton.setText("Reset");
        this.resetButton.setLayoutData((Object)new GridData());
        Label label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        gridData = new GridData();
        label = new Label(composite1, 0);
        label.setText("Limit");
        label.setLayoutData((Object)new GridData());
        this.limitText = new Text(composite1, 133120);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 80;
        this.limitText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(1, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        this.calendarComposite = new CalendarComposite();
        this.calendarComposite.setYearText(this.alarmStartYearText);
        this.calendarComposite.setMonthText(this.alarmStartMonthText);
        this.calendarComposite.setDateText(this.alarmStartDateText);
        this.calendarComposite.createCalendarView(composite2);
        GridLayout gridLayout3 = new GridLayout(9, false);
        Composite composite3 = new Composite(composite0, 0);
        composite3.setLayoutData((Object)new GridData(256));
        composite3.setLayout((Layout)gridLayout3);
        Button startDateRadio = new Button(composite3, 16);
        startDateRadio.setText("Start date");
        startDateRadio.setSelection(true);
        GridData startGridData = new GridData();
        startGridData.horizontalSpan = 3;
        startGridData.verticalSpan = 1;
        startDateRadio.setLayoutData((Object)startGridData);
        label = new Label(composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartYearText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmStartYearText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartMonthText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartMonthText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartDateText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartDateText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startHourCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.startHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.startHourCombo);
        this.startHourCombo.select(0);
        label = new Label(composite3, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startMinuteCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.startMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.startMinuteCombo);
        this.startMinuteCombo.select(0);
        Button endDateRadio = new Button(composite3, 16);
        endDateRadio.setText("End date");
        endDateRadio.setSelection(false);
        GridData endGridData = new GridData();
        endGridData.horizontalSpan = 3;
        endGridData.verticalSpan = 1;
        endDateRadio.setLayoutData((Object)endGridData);
        label = new Label(composite3, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndYearText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmEndYearText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndMonthText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndMonthText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndDateText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndDateText.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endHourCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.endHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.endHourCombo);
        this.endHourCombo.select(0);
        label = new Label(composite3, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endMinuteCombo = new Combo(composite3, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.endMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.endMinuteCombo);
        this.endMinuteCombo.select(0);
        this.calendarComposite.setYearText(this.alarmStartYearText);
        this.calendarComposite.setMonthText(this.alarmStartMonthText);
        this.calendarComposite.setDateText(this.alarmStartDateText);
        this.dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        startDateRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CalendarView.this.calendarComposite.setYearText(CalendarView.this.alarmStartYearText);
                CalendarView.this.calendarComposite.setMonthText(CalendarView.this.alarmStartMonthText);
                CalendarView.this.calendarComposite.setDateText(CalendarView.this.alarmStartDateText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        endDateRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CalendarView.this.calendarComposite.setYearText(CalendarView.this.alarmEndYearText);
                CalendarView.this.calendarComposite.setMonthText(CalendarView.this.alarmEndMonthText);
                CalendarView.this.calendarComposite.setDateText(CalendarView.this.alarmEndDateText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CalendarView.this.setButton.setEnabled(false);
                try {
                    try {
                        String limitString = CalendarView.this.limitText.getText();
                        CalendarView.this.limit = Integer.parseInt(limitString);
                        CalendarView.this.createDataInfo();
                        DataFilterInfo.getInstance().setStartDateValue(CalendarView.this.startDateString);
                        DataFilterInfo.getInstance().setEndDateValue(CalendarView.this.endDateString);
                        DataFilterInfo.getInstance().setLimit(CalendarView.this.limit);
                        Date workDate = Calendar.getInstance().getTime();
                        if (CalendarView.this.startDateString != null && !CalendarView.this.startDateString.equals("")) {
                            workDate.setTime(Long.parseLong(CalendarView.this.startDateString));
                            DataFilterInfo.getInstance().setStartDate(CalendarView.this.dateformat.format(workDate));
                        }
                        if (CalendarView.this.endDateString != null && !CalendarView.this.endDateString.equals("")) {
                            workDate.setTime(Long.parseLong(CalendarView.this.endDateString));
                            DataFilterInfo.getInstance().setEndDate(CalendarView.this.dateformat.format(workDate));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                finally {
                    CalendarView.this.setButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.resetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CalendarView.this.resetButton.setEnabled(false);
                try {
                    CalendarView.this.startDateString = null;
                    CalendarView.this.endDateString = null;
                    CalendarView.this.limit = 0;
                    CalendarView.this.limitText.setText("0");
                    DataFilterInfo.getInstance().setStartDateValue(null);
                    DataFilterInfo.getInstance().setEndDateValue(null);
                    DataFilterInfo.getInstance().setLimit(CalendarView.this.limit);
                    CalendarView.this.alarmStartYearText.setText("");
                    CalendarView.this.alarmStartMonthText.setText("");
                    CalendarView.this.alarmStartDateText.setText("");
                    CalendarView.this.alarmEndYearText.setText("");
                    CalendarView.this.alarmEndMonthText.setText("");
                    CalendarView.this.alarmEndDateText.setText("");
                    CalendarView.this.startHourCombo.select(0);
                    CalendarView.this.startMinuteCombo.select(0);
                    CalendarView.this.endHourCombo.select(0);
                    CalendarView.this.endMinuteCombo.select(0);
                }
                finally {
                    CalendarView.this.resetButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setCalendarInfo();
    }

    private void setHourCombo(Combo combo) {
        int i = 0;
        while (i < 24) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setMinuteCombo(Combo combo) {
        int i = 0;
        while (i < 60) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setCalendarInfo() {
        this.limitText.setText(Integer.toString(DataFilterInfo.getInstance().getLimit()));
        String startDateWorkString = "";
        String endDateWorkString = "";
        if (DataFilterInfo.getInstance().getStartDateValue() == null) {
            return;
        }
        startDateWorkString = DataFilterInfo.getInstance().getStartDateValue();
        if (DataFilterInfo.getInstance().getEndDateValue() == null) {
            return;
        }
        endDateWorkString = DataFilterInfo.getInstance().getEndDateValue();
        try {
            long startDateLong = Long.parseLong(startDateWorkString);
            Date startDate = new Date(startDateLong);
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            this.alarmStartYearText.setText(Integer.toString(cal.get(1)));
            this.alarmStartMonthText.setText(Integer.toString(cal.get(2) + 1));
            this.alarmStartDateText.setText(Integer.toString(cal.get(5)));
            String work = Integer.toString(cal.get(11));
            if (work.length() == 1) {
                work = "0" + work;
            }
            this.startHourCombo.setText(work);
            work = Integer.toString(cal.get(12));
            if (work.length() == 1) {
                work = "0" + work;
            }
            this.startMinuteCombo.setText(work);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            Date endDate = new Date(Long.parseLong(endDateWorkString));
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            this.alarmEndYearText.setText(Integer.toString(cal.get(1)));
            this.alarmEndMonthText.setText(Integer.toString(cal.get(2) + 1));
            this.alarmEndDateText.setText(Integer.toString(cal.get(5)));
            String work = Integer.toString(cal.get(11));
            if (work.length() == 1) {
                work = "0" + work;
            }
            this.endHourCombo.setText(work);
            work = Integer.toString(cal.get(12));
            if (work.length() == 1) {
                work = "0" + work;
            }
            this.endMinuteCombo.setText(work);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void createDataInfo() {
        Calendar cal;
        int year = 0;
        int month = 0;
        int date = 0;
        int hour = 0;
        int minute = 0;
        if (this.alarmStartYearText.getText() != null && !this.alarmStartYearText.getText().equals("")) {
            String startYearString = this.alarmStartYearText.getText();
            String startMonthString = this.alarmStartMonthText.getText();
            String startDateWorkString = this.alarmStartDateText.getText();
            String startHourString = this.startHourCombo.getText();
            String startMinuteString = this.startMinuteCombo.getText();
            try {
                year = Integer.parseInt(startYearString);
                month = Integer.parseInt(startMonthString);
                date = Integer.parseInt(startDateWorkString);
                hour = Integer.parseInt(startHourString);
                minute = Integer.parseInt(startMinuteString);
                cal = Calendar.getInstance();
                cal.set(year, month - 1, date, hour, minute);
                this.startDateString = Long.toString(cal.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (this.alarmEndYearText.getText() != null && !this.alarmEndYearText.getText().equals("")) {
            String endYearString = this.alarmEndYearText.getText();
            String endMonthString = this.alarmEndMonthText.getText();
            String endDateWorkString = this.alarmEndDateText.getText();
            String endHourString = this.endHourCombo.getText();
            String endMinuteString = this.endMinuteCombo.getText();
            try {
                year = Integer.parseInt(endYearString);
                month = Integer.parseInt(endMonthString);
                date = Integer.parseInt(endDateWorkString);
                hour = Integer.parseInt(endHourString);
                minute = Integer.parseInt(endMinuteString);
                cal = Calendar.getInstance();
                cal.set(year, month - 1, date, hour, minute);
                this.endDateString = Long.toString(cal.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

