/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.mail;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.engine.mail.MailSendFilter;
import netjfwatcher.engine.mail.MailSendInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

public final class MailSendInfoList {
    private static final int MAIL_QUEUE_LIST_SIZE = 100;
    private static Logger logger = null;
    private List mailList = Collections.synchronizedList(new LinkedList());

    private MailSendInfoList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void setMailList(String subject, String messageBody, String errorLevel, String errorCode) {
        if (!MailSendFilter.getInstance().checkAlarmLevelFilter(errorLevel)) {
            ResourceInfo resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
            logger.info("Mail filtering error level code=" + resourceInfo.getMailFilterErrorLevel() + " ,Alarm level code=" + errorLevel);
            return;
        }
        if (!MailSendFilter.getInstance().checkMessageFilter(messageBody)) {
            ResourceInfo resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
            logger.info("Mail filtering message=" + resourceInfo.getMailFilterString() + " , Alarm message=" + messageBody);
            return;
        }
        if (this.mailList.size() > 100) {
            this.mailList.remove(0);
            logger.warning("Remove mail list for over mail queue list (size=" + this.mailList.size() + ")");
        }
        MailSendInfo info = new MailSendInfo();
        info.setSubject(subject);
        info.setMessageBody(messageBody);
        info.setErrorLevel(errorLevel);
        info.setErrorCode(errorCode);
        this.mailList.add(info);
    }

    public synchronized MailSendInfo getMailInfo() {
        MailSendInfo info = null;
        if (this.mailList.size() == 0) {
            return null;
        }
        info = (MailSendInfo)this.mailList.get(0);
        this.mailList.remove(0);
        return info;
    }

    public static MailSendInfoList getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ MailSendInfoList(MailSendInfoList mailSendInfoList) {
        this();
    }

    private static class SingletonResource {
        static final MailSendInfoList RESOURCE = new MailSendInfoList(null);

        private SingletonResource() {
        }
    }
}

