/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.noderegister.snmp.NodeSnmpRegisterInitializeThread;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePopControl;
import netjfwatcher.engine.server.protocol.control.ListQueueSmtpControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.snmpmanager.statistics.ThreadStatisticsMibGetControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;

public final class NodeEdit {
    private static Logger logger = null;
    private NodeWatchInfo nodewatchinfo;

    private NodeEdit() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void editNodeInfo(CommandInfo com) {
        NodeInformation editNewNodeInfo = com.getNodeInformation();
        try {
            this.editNodeInfo(editNewNodeInfo);
        }
        catch (SQLException e1) {
            logger.warning("SQLException " + e1.getMessage());
            return;
        }
        catch (DatabaseConnectionException e1) {
            logger.warning("DatabaseConnectionException " + e1.getMessage());
            return;
        }
    }

    public void editNodeInfo(NodeInformation editNewNodeInfo) throws DatabaseConnectionException, SQLException {
        boolean isRestartPingThread = false;
        boolean isRestartSNMPThread = false;
        NodeInformation updateNodeInfo = null;
        NodeInformation workNodeInfo = null;
        String ipaddress = editNewNodeInfo.getIpaddress();
        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
        try {
            ArrayList list = nodeRegisterDBTable.findTarget(ipaddress);
            workNodeInfo = (NodeInformation)list.get(0);
            nodeRegisterDBTable.updateNode(editNewNodeInfo);
            list = nodeRegisterDBTable.findTarget(ipaddress);
            updateNodeInfo = (NodeInformation)list.get(0);
        }
        catch (SQLException e1) {
            logger.warning("SQLException " + e1.getMessage());
            throw e1;
        }
        catch (DatabaseConnectionException e1) {
            logger.warning("DatabaseConnectionException " + e1.getMessage());
            throw e1;
        }
        String nowSnmpPerid = workNodeInfo.getSnmpPeriod();
        String newSnmpPerid = editNewNodeInfo.getSnmpPeriod();
        String nowSnmpLevel = workNodeInfo.getSnmpLevel();
        String newSnmpLevel = editNewNodeInfo.getSnmpLevel();
        String nowSnmpVersion = workNodeInfo.getSnmpVersion();
        String newSnmpVersion = editNewNodeInfo.getSnmpVersion();
        String nowSnmpCommunity = workNodeInfo.getRoCommunity();
        String newSnmpCommunity = editNewNodeInfo.getRoCommunity();
        if (!(nowSnmpPerid.equals(newSnmpPerid) && nowSnmpLevel.equals(newSnmpLevel) && nowSnmpVersion.equals(newSnmpVersion) && nowSnmpCommunity.equals(newSnmpCommunity))) {
            isRestartSNMPThread = true;
        }
        String nowPingPerid = workNodeInfo.getPingPeriod();
        String newPingPerid = editNewNodeInfo.getPingPeriod();
        String nowPingThreshold = workNodeInfo.getPingThreshold();
        String newPingThreshold = editNewNodeInfo.getPingThreshold();
        if (!nowPingPerid.equals(newPingPerid) || !nowPingThreshold.equals(newPingThreshold)) {
            isRestartPingThread = true;
        }
        this.nodewatchinfo = new NodeWatchInfo();
        String snmpVersion = updateNodeInfo.getSnmpVersion();
        if (snmpVersion.equals("SNMPV1")) {
            this.nodewatchinfo.setSnmpVersion(0);
        } else if (snmpVersion.equals("SNMPV2C")) {
            this.nodewatchinfo.setSnmpVersion(1);
        } else if (snmpVersion.equals("SNMPV3")) {
            this.nodewatchinfo.setSnmpVersion(3);
        } else {
            logger.warning("Bad snmp version : " + snmpVersion);
        }
        this.nodewatchinfo.setIpaddress(updateNodeInfo.getIpaddress());
        this.nodewatchinfo.setNodename(updateNodeInfo.getNodename());
        this.nodewatchinfo.setPingPeriod(updateNodeInfo.getPingPeriod());
        this.nodewatchinfo.setPingThreshold(updateNodeInfo.getPingThreshold());
        this.nodewatchinfo.setSnmpPeriod(updateNodeInfo.getSnmpPeriod());
        this.nodewatchinfo.setSnmpLevel(updateNodeInfo.getSnmpLevel());
        this.nodewatchinfo.setSnmpROCommunity(updateNodeInfo.getRoCommunity());
        this.nodewatchinfo.setSnmpRWCommunity(updateNodeInfo.getRwCommunity());
        this.nodewatchinfo.setHttpUrl(updateNodeInfo.getHttpUrl());
        this.nodewatchinfo.setHttpPeriod(updateNodeInfo.getHttpPeriod());
        this.nodewatchinfo.setHttpTimeout(updateNodeInfo.getHttpTimeout());
        this.nodewatchinfo.setPopPeriod(updateNodeInfo.getPopPeriod());
        this.nodewatchinfo.setPopUser(updateNodeInfo.getPopUser());
        this.nodewatchinfo.setPopPassword(updateNodeInfo.getPopPassword());
        this.nodewatchinfo.setPopPort(updateNodeInfo.getPopPort());
        this.nodewatchinfo.setPopTimeout(updateNodeInfo.getPopTimeout());
        this.nodewatchinfo.setSmtpPeriod(updateNodeInfo.getSmtpPeriod());
        this.nodewatchinfo.setSmtpPort(updateNodeInfo.getSmtpPort());
        this.nodewatchinfo.setSmtpTimeout(updateNodeInfo.getSmtpTimeout());
        this.nodewatchinfo.setSmtpTestAddress(updateNodeInfo.getSmtpSendAddress());
        this.nodewatchinfo.setSmtpCheckPop3Host(updateNodeInfo.getSmtpCheckHost());
        this.nodewatchinfo.setSmtpCheckPop3User(updateNodeInfo.getSmtpCheckUser());
        this.nodewatchinfo.setSmtpCheckPop3Password(updateNodeInfo.getSmtpCheckPassword());
        this.nodewatchinfo.setSmtpCheckPop3Port(updateNodeInfo.getSmtpCheckPort());
        this.nodewatchinfo.setSmtpCheckPop3Timeout(updateNodeInfo.getSmtpCheckTimeout());
        this.nodewatchinfo.setDatabaseWatcherInfo(updateNodeInfo.getDatabaseWatcherInfo());
        this.setThreadList(this.nodewatchinfo, isRestartPingThread, isRestartSNMPThread);
    }

    private void setThreadList(NodeWatchInfo nodewatchinfo, boolean isRestartPingThread, boolean isRestartSNMPThread) {
        NodeWatchInfo info;
        int pingPeriod = 0;
        int snmpLevel = 0;
        int snmpPeriod = 0;
        int httpPeriod = 0;
        int pop3Period = 0;
        int smtpPeriod = 0;
        String ipaddress = nodewatchinfo.getIpaddress();
        int version = nodewatchinfo.getSnmpVersion();
        String roCommunity = nodewatchinfo.getSnmpROCommunity();
        String threshHold = nodewatchinfo.getPingThreshold();
        try {
            if (!nodewatchinfo.getPingPeriod().equals("--")) {
                pingPeriod = Integer.parseInt(nodewatchinfo.getPingPeriod());
            }
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        try {
            if (!nodewatchinfo.getHttpPeriod().equals("--")) {
                httpPeriod = Integer.parseInt(nodewatchinfo.getHttpPeriod());
            }
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        try {
            snmpLevel = Integer.parseInt(nodewatchinfo.getSnmpLevel());
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        try {
            if (!nodewatchinfo.getSnmpPeriod().equals("--")) {
                snmpPeriod = Integer.parseInt(nodewatchinfo.getSnmpPeriod());
            }
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        try {
            if (!nodewatchinfo.getPopPeriod().equals("--")) {
                pop3Period = Integer.parseInt(nodewatchinfo.getPopPeriod());
            }
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        try {
            if (!nodewatchinfo.getSmtpPeriod().equals("--")) {
                smtpPeriod = Integer.parseInt(nodewatchinfo.getSmtpPeriod());
            }
        }
        catch (NumberFormatException e) {
            logger.warning(e.getMessage());
        }
        if (isRestartPingThread) {
            logger.info("SNMP Thread Restart");
            if (pingPeriod > 0) {
                info = new NodeWatchInfo();
                info.setPingPeriod(Integer.toString(pingPeriod));
                info.setSnmpROCommunity(roCommunity);
                info.setPingThreshold(threshHold);
                info.setIpaddress(ipaddress);
                info.setNodename(nodewatchinfo.getNodename());
                ListQueuePingControl.getInstance().setPingNode(ipaddress, info);
            } else {
                ListQueuePingControl.getInstance().removePingNode(ipaddress);
            }
        }
        if (httpPeriod > 0) {
            info = new NodeWatchInfo();
            info.setHttpPeriod(Integer.toString(httpPeriod));
            info.setHttpUrl(nodewatchinfo.getHttpUrl());
            info.setHttpTimeout(nodewatchinfo.getHttpTimeout());
            info.setIpaddress(ipaddress);
            info.setNodename(nodewatchinfo.getNodename());
            ListQueueHTTPControl.getInstance().setHTTPNode(ipaddress, info);
        } else {
            ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);
        }
        if (pop3Period > 0) {
            info = new NodeWatchInfo();
            info.setPopPeriod(Integer.toString(pop3Period));
            info.setPopUser(nodewatchinfo.getPopUser());
            info.setPopPassword(nodewatchinfo.getPopPassword());
            info.setPopPort(nodewatchinfo.getPopPort());
            info.setPopTimeout(nodewatchinfo.getPopTimeout());
            info.setIpaddress(ipaddress);
            info.setNodename(nodewatchinfo.getNodename());
            ListQueuePopControl.getInstance().setPop3Node(ipaddress, info);
        } else {
            ListQueuePopControl.getInstance().removePopNode(ipaddress);
        }
        if (smtpPeriod > 0) {
            info = new NodeWatchInfo();
            info.setSmtpPeriod(Integer.toString(smtpPeriod));
            info.setSmtpPort(nodewatchinfo.getSmtpPort());
            info.setSmtpTimeout(nodewatchinfo.getSmtpTimeout());
            info.setSmtpTestAddress(nodewatchinfo.getSmtpTestAddress());
            info.setSmtpCheckPop3Host(nodewatchinfo.getSmtpCheckPop3Host());
            info.setSmtpCheckPop3User(nodewatchinfo.getSmtpCheckPop3User());
            info.setSmtpCheckPop3Password(nodewatchinfo.getSmtpCheckPop3Password());
            info.setSmtpCheckPop3Port(nodewatchinfo.getSmtpCheckPop3Port());
            info.setSmtpCheckPop3Timeout(nodewatchinfo.getSmtpCheckPop3Timeout());
            info.setIpaddress(ipaddress);
            info.setNodename(nodewatchinfo.getNodename());
            ListQueueSmtpControl.getInstance().setSmtpNode(ipaddress, info);
        } else {
            ListQueueSmtpControl.getInstance().removeSmtpNode(ipaddress);
        }
        DatabaseWatcherInfo databaseWatcherInfo = nodewatchinfo.getDatabaseWatcherInfo();
        if (databaseWatcherInfo != null) {
            String databaseInfoPeriod = databaseWatcherInfo.getWatcherPeriod();
            int databaseInfoPeriodData = 0;
            if (databaseInfoPeriod == null || !databaseInfoPeriod.equals("--")) {
                try {
                    databaseInfoPeriodData = Integer.parseInt(databaseInfoPeriod);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("database watch period : " + databaseInfoPeriod);
                }
            }
            if (databaseInfoPeriodData > 0) {
                NodeWatchInfo info2 = new NodeWatchInfo();
                info2.setIpaddress(ipaddress);
                info2.setNodename(nodewatchinfo.getNodename());
                info2.setDatabaseWatcherInfo(nodewatchinfo.getDatabaseWatcherInfo());
                ListQueueDatabaseWatchControl.getInstance().setDatabaseNode(ipaddress, info2);
            } else {
                ListQueueDatabaseWatchControl.getInstance().removeDatabaseNode(ipaddress);
            }
        }
        if (isRestartSNMPThread) {
            this.setSNMPThread(ipaddress, snmpLevel, version, snmpPeriod, roCommunity);
        }
    }

    private void setSNMPThread(String ipaddress, int snmpLevel, int version, int snmpPeriod, String roCommunity) {
        NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(ipaddress);
        if (nodeInfo != null) {
            StatisticsMibInfo mibInfo;
            String systemMibStatus = nodeInfo.getSystemMIBStatus();
            String statisticsMibStatus = nodeInfo.getStatisticsMIBStatus();
            String interfaceMibStatus = nodeInfo.getInterfaceMIBStatus();
            String printMibStatus = nodeInfo.getPrintMIBStatus();
            if (snmpPeriod != 0 && systemMibStatus.equals("Pending") && interfaceMibStatus.equals("Pending") && (!this.nodewatchinfo.getNodeKind().equals("Printer") || !printMibStatus.equals("Pending")) && snmpLevel > 0) {
                Thread t = new Thread(new NodeSnmpRegisterInitializeThread(ipaddress, version, snmpPeriod, roCommunity, snmpLevel, this.nodewatchinfo.getNodeKind()));
                t.setDaemon(true);
                t.setName("SNMPInitThread:" + ipaddress + " : ");
                t.start();
            }
            ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(ipaddress);
            ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(ipaddress);
            if (snmpPeriod == 0) {
                return;
            }
            if (snmpLevel > 0) {
                NodeWatchInfo info2 = new NodeWatchInfo();
                info2.setSnmpPeriod(this.nodewatchinfo.getSnmpPeriod());
                info2.setSnmpROCommunity(roCommunity);
                info2.setIpaddress(ipaddress);
                info2.setNodeKind(this.nodewatchinfo.getNodeKind());
                ListQueueDefaultSnmpMibControl.getInstance().setDefaultSnmpNode(ipaddress, info2);
            }
            if (snmpLevel == 2) {
                if (statisticsMibStatus.equals("Pending")) {
                    ThreadStatisticsMibGetControl ifoctet = new ThreadStatisticsMibGetControl();
                    ifoctet.editNodeSnmpInfo(this.nodewatchinfo.getIpaddress(), this.nodewatchinfo.getSnmpVersion(), this.nodewatchinfo.getSnmpROCommunity(), this.nodewatchinfo.getSnmpPeriod(), "1.3.6.1.2.1.2.2.1.10");
                    ifoctet.editNodeSnmpInfo(this.nodewatchinfo.getIpaddress(), this.nodewatchinfo.getSnmpVersion(), this.nodewatchinfo.getSnmpROCommunity(), this.nodewatchinfo.getSnmpPeriod(), "1.3.6.1.2.1.2.2.1.16");
                }
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setNodeName(this.nodewatchinfo.getNodename());
                mibInfo.setVersion(version);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.2.1.2.2.1.10", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.2.1.2.2.1.16", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            }
            if (snmpLevel == 3) {
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setNodeName(nodeInfo.getNodename());
                mibInfo.setVersion(version);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.4.1.2021.10.1.3", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            }
            if (snmpLevel == 4) {
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setNodeName(nodeInfo.getNodename());
                mibInfo.setVersion(version);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.6", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.7", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
                mibInfo = StatisticsMibInfo.getInstance(ipaddress);
                mibInfo.setCommunity(roCommunity);
                mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.8", this.nodewatchinfo.getSnmpPeriod(), "0", "");
                ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            }
        }
    }

    public static NodeEdit getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ NodeEdit(NodeEdit nodeEdit) {
        this();
    }

    private static class SingletonResource {
        static final NodeEdit RESOURCE = new NodeEdit(null);

        private SingletonResource() {
        }
    }
}

