/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PingPreferancePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    public static final String PING_DEFAULT_TIMEOUT = "4000";
    public static final String PING_DEFAULT_COUNT = "4";
    public static final int TEXT_WIDTH = 120;
    private static Logger logger;
    private ResourceInfo resourceInfo;
    private Text pingTimeoutText;
    private Text pingCountText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Ping Timeout(ms)");
        label.setLayoutData((Object)new GridData());
        this.pingTimeoutText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Ping Count");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.pingCountText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.pingCountText.setLayoutData((Object)gridData);
        this.showPingProp();
        return composite;
    }

    private void showPingProp() {
        this.pingTimeoutText.setText(this.resourceInfo.getPingTimeout());
        this.pingCountText.setText(this.resourceInfo.getPingRetry());
    }

    protected void performDefaults() {
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.resourceInfo.setPingTimeout(PING_DEFAULT_TIMEOUT);
        this.resourceInfo.setPingRetry(PING_DEFAULT_COUNT);
        this.showPingProp();
    }

    public boolean performOk() {
        this.resourceInfo.setPingTimeout(this.pingTimeoutText.getText());
        this.resourceInfo.setPingRetry(this.pingCountText.getText());
        this.saveResourceXMLInfo(this.resourceInfo);
        return super.performOk();
    }
}

