/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.snmpmanager.process.AbstractManagerMessageProcessingSubsystem;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MPDiscoveryAgent;
import netjfwatcher.engine.snmpmanager.process.ManagerV3MessageInfo;
import netjfwatcher.engine.snmpmanager.process.SnmpRequestIDManager;
import netjfwatcher.engine.snmpmanager.process.SnmpStatisticsManager;
import netjfwatcher.engine.snmpmanager.process.SnmpV3MsgID;
import netjfwatcher.engine.snmpmanager.process.SnmpV3MsgIDManager;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpmanager.SnmpManagerQueue;

public class ManagerV3MP
extends AbstractManagerMessageProcessingSubsystem {
    private static Logger logger;
    private boolean authFlag = false;
    private boolean privFlag = false;
    private DateFormat simpleDateformat = new SimpleDateFormat("HH:mm:ss");

    public ManagerV3MP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ManagerV3MP(DatagramSocket dSocket, InetAddress hostAddress, String community) throws SnmpConfigurationException, SnmpV3ConfigurationException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;
        this.setConfig(dSocket, hostAddress);
    }

    public void setManagerMP(DatagramSocket dSocket, InetAddress hostAddress, String community) throws SnmpConfigurationException, SnmpV3ConfigurationException {
        this.version = 3;
        this.dSocket = dSocket;
        this.targetAddress = hostAddress;
        this.community = community;
        this.setConfig(dSocket, hostAddress);
    }

    public SnmpVarBindList getProcess(byte code, String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException, SnmpV3ConfigurationException, IOException {
        SnmpVarBindList returnVarBindList = null;
        try {
            this.learnedSnmpV3Agent();
        }
        catch (GeneralSecurityException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        switch (code) {
            case -96: {
                returnVarBindList = this.getMIBEntry(requestOID);
                break;
            }
            case -95: {
                returnVarBindList = this.getNextMIBEntry(requestOID);
                break;
            }
            default: {
                logger.warning("Unknown code : " + this.hexByte(code));
            }
        }
        return returnVarBindList;
    }

    public SnmpVarBindList setProcess(byte code, String requestOID, AbstractSnmpObject newValue) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpV3AuthAbortException, SnmpSetException, SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        SnmpVarBindList returnVarBindList = null;
        try {
            this.learnedSnmpV3Agent();
        }
        catch (GeneralSecurityException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        switch (code) {
            case -93: {
                returnVarBindList = this.setMIBEntry(requestOID, newValue);
                break;
            }
            default: {
                logger.warning("Undefined command code : " + this.hexByte(code));
            }
        }
        return returnVarBindList;
    }

    private void learnedSnmpV3Agent() throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException {
        ManagerV3MessageInfo receiveMessageInfo = null;
        int engineBoots = 0;
        long engineTime = 0L;
        long agentStartTime = 0L;
        Date agentDate = null;
        if (this.snmpV3ManagerConfInfo == null) {
            throw new SnmpV3ConfigurationException("Not Found SNMPV3 Config IP=" + this.targetAddress.toString());
        }
        if (!this.snmpV3ManagerConfInfo.isLearned()) {
            logger.info("Learned TargetIP=" + this.targetAddress.toString() + " EngineID=" + this.snmpV3ManagerConfInfo.getSnmpEngineID());
            ManagerV3MPDiscoveryAgent managerDiscoveryAgent = new ManagerV3MPDiscoveryAgent(this.dSocket, this.targetAddress, this.community);
            try {
                receiveMessageInfo = managerDiscoveryAgent.discoveryAgent();
            }
            catch (GeneralSecurityException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            if (receiveMessageInfo != null) {
                engineBoots = receiveMessageInfo.getMsgAuthoritativeBoots();
                this.snmpV3ManagerConfInfo.setSnmpEngineBoots(Integer.toString(engineBoots));
                engineTime = receiveMessageInfo.getMsgAuthoritativeEngineTime();
                agentStartTime = System.currentTimeMillis() - engineTime * 1000L;
                this.snmpV3ManagerConfInfo.setSnmpEngineTime(Long.toString(agentStartTime));
                this.snmpV3ManagerConfInfo.setLearned(true);
                agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentStartTime);
                logger.info("Agent EngineTime : " + engineTime);
                logger.info("Agent Start date : " + agentDate.toString());
                SnmpV3ManagerConfig.getInstance().getResourceFileParse().updateSnmpV3ManagerConfigInfo(this.targetAddress.getHostAddress(), this.snmpV3ManagerConfInfo);
                HashMap snmpV3ConfigEngineIDList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigEngineIDMapList();
                snmpV3ConfigEngineIDList.put(this.snmpV3ManagerConfInfo.getSnmpEngineID(), this.snmpV3ManagerConfInfo);
            }
        } else {
            logger.info("Already Learned TargetIP=" + this.targetAddress.toString() + " EngineID=" + this.snmpV3ManagerConfInfo.getSnmpEngineID());
        }
    }

    public SnmpVarBindList getMIBEntry(String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpBadValueException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, SnmpErrorStatusException, IOException {
        SnmpVarBindList retrievedVars = null;
        SnmpSequence sequenceData = null;
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        int msgID = SnmpV3MsgIDManager.getInstance().getMsgID(Thread.currentThread().getName(), requestOID);
        try {
            sequenceData = this.createSNMPV3Message(msgID, this.snmpV3ManagerConfInfo, this.snmpV3UserName, requestID, requestOID, (byte)-95, new SnmpNull());
        }
        catch (SnmpV3ConfigurationException e2) {
            e2.printStackTrace();
            throw new SnmpV3DecryptAbortException(e2.getMessage());
        }
        retrievedVars = this.sendData(requestID, msgID, requestOID, sequenceData);
        return retrievedVars;
    }

    public SnmpVarBindList getNextMIBEntry(String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpBadValueException, SnmpV3ConfigurationException, IOException {
        SnmpVarBindList retrievedVars = null;
        SnmpSequence sequenceData = null;
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        int msgID = SnmpV3MsgIDManager.getInstance().getMsgID(Thread.currentThread().getName(), requestOID);
        sequenceData = this.createSNMPV3Message(msgID, this.snmpV3ManagerConfInfo, this.snmpV3UserName, requestID, requestOID, (byte)-95, new SnmpNull());
        retrievedVars = this.sendData(requestID, msgID, requestOID, sequenceData);
        return retrievedVars;
    }

    public SnmpVarBindList setMIBEntry(String requestOID, AbstractSnmpObject newValue) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpSetException, SnmpMIBGetException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpV3ConfigurationException, IOException {
        SnmpVarBindList retrievedVars = null;
        SnmpSequence sequenceData = null;
        int requestID = SnmpRequestIDManager.getInstance().getRequestID(Thread.currentThread().getName(), requestOID);
        int msgID = SnmpV3MsgIDManager.getInstance().getMsgID(Thread.currentThread().getName(), requestOID);
        try {
            sequenceData = this.createSNMPV3Message(msgID, this.snmpV3ManagerConfInfo, this.snmpV3UserName, requestID, requestOID, (byte)-93, newValue);
        }
        catch (SnmpV3ConfigurationException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }
        retrievedVars = this.sendData(requestID, msgID, requestOID, sequenceData);
        return retrievedVars;
    }

    private SnmpVarBindList sendData(int requestID, int msgID, String requestOID, SnmpSequence sequenceData) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, NoRouteToHostException, SocketTimeoutException, IOException {
        SnmpVarBindList retrievedVars = null;
        DatagramPacket inPacket = null;
        try {
            byte[] sendByteData = sequenceData.getBEREncoding();
            this.dSocket.connect(this.targetAddress, this.snmpPort);
            while (true) {
                try {
                    AlarmMessageMake message;
                    inPacket = new DatagramPacket(new byte[8196], 8196);
                    this.sendByteDataToAgent(sendByteData, requestOID, this.dSocket);
                    this.dSocket.receive(inPacket);
                    int socketTimeout = this.dSocket.getSoTimeout();
                    if (AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "4")) {
                        message = AlarmMessageMake.getInstance();
                        message.setRecoverySNMPTimeout(this.targetAddress.getHostAddress(), requestOID, socketTimeout);
                    }
                    if (AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "5")) {
                        message = AlarmMessageMake.getInstance();
                        message.setRecoverySNMPNoRouteToHost(this.targetAddress.getHostAddress(), requestOID);
                    }
                    if (AlarmRecovery.getInstance().isOccurredAlarmId(this.targetAddress.getHostAddress(), "6")) {
                        message = AlarmMessageMake.getInstance();
                        message.setRecoverySNMPIOException(this.targetAddress.getHostAddress(), requestOID);
                    }
                    byte[] receiveDataByte = inPacket.getData();
                    logger.finer("Receive data : " + this.hexBytetoString(receiveDataByte, inPacket.getLength()));
                    Date date = Calendar.getInstance().getTime();
                    SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive data : " + this.simpleDateformat.format(date) + " : ");
                    SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(receiveDataByte, inPacket.getLength()));
                    ManagerV3MessageInfo receiveMessageInfo = this.parseSnmpV3ReceiveData(receiveDataByte, requestID, msgID, requestOID);
                    retrievedVars = receiveMessageInfo.getRetrievedVars();
                    break;
                }
                catch (SnmpUnmuchRequestIDException e1) {
                    --this.retryCounter;
                    logger.info("SnmpUnmuchRequestIDException Retry : " + this.retryCounter);
                    if (this.retryCounter <= 0) {
                        AlarmMessageMake message = AlarmMessageMake.getInstance();
                        message.setErrorSNMPUnmuchRequestID(this.targetAddress.getHostAddress(), e1.getMessage());
                        throw e1;
                    }
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (NoRouteToHostException e1) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPNoRouteToHost(this.targetAddress.getHostAddress(), requestOID);
                    logger.warning("GetNext Request send data : " + e1.getMessage());
                    e1.printStackTrace();
                    throw e1;
                }
                catch (SocketTimeoutException e) {
                    SnmpStatisticsManager.getInstance().addSnmpSocketTimeout(this.targetAddress.getHostAddress());
                    if (this.retryCounter <= 0) {
                        int socketTimeout = this.dSocket.getSoTimeout();
                        AlarmMessageMake message = AlarmMessageMake.getInstance();
                        message.setErrorSNMPTimeout(this.targetAddress.getHostAddress(), requestOID, socketTimeout);
                        logger.warning(String.valueOf(e.getMessage()) + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                        throw new SocketTimeoutException("Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID + " : " + e.getMessage());
                    }
                    logger.warning("Socket timeout retry=" + this.retryCounter);
                }
                catch (IOException e) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPIOException(this.targetAddress.getHostAddress(), requestOID, e.getMessage());
                    logger.warning(String.valueOf(e.getMessage()) + " : " + this.targetAddress.getHostAddress() + " : " + requestOID);
                    throw new IOException("Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID + " : " + e.getMessage());
                }
                --this.retryCounter;
            }
        }
        finally {
            this.dSocket.disconnect();
        }
        return retrievedVars;
    }

    public ManagerV3MessageInfo parseSnmpV3ReceiveData(byte[] receiveData, int requestID, int requestMsgID, String requestOID) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpErrorStatusException, SnmpBadValueException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException {
        ManagerV3MessageInfo receiveMessageInfo = new ManagerV3MessageInfo();
        SnmpV3ManagerConfigInfo snmpV3ConfigInformation = null;
        SnmpV3ManagerUserConfigInfo userConfigInfo = null;
        AbstractSnmpObject msgVersion = null;
        AbstractSnmpObject msgID = null;
        AbstractSnmpObject msgMaxSize = null;
        AbstractSnmpObject msgFlags = null;
        int receiveMsgFlags = 0;
        AbstractSnmpObject msgSecurityModel = null;
        AbstractSnmpObject msgAuthoritativeEngineID = null;
        AbstractSnmpObject msgAuthoritativeBoots = null;
        AbstractSnmpObject msgAuthoritativeEngineTime = null;
        AbstractSnmpObject msgUserName = null;
        SnmpSequence request = new SnmpSequence();
        SNMPTLV nextTLV = request.extractNextTLV(receiveData, 0);
        try {
            request.setTLV(nextTLV);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Snmp V3 receive data parse : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        msgVersion = request.getSNMPObjectAt(0);
        if (!(msgVersion instanceof SnmpInteger)) {
            logger.warning("Version is not INTEGER : " + msgVersion);
            throw new SnmpBadValueException("Version is not INTEGER : " + msgVersion);
        }
        SnmpSequence header = (SnmpSequence)request.getSNMPObjectAt(1);
        msgID = header.getSNMPObjectAt(0);
        msgMaxSize = header.getSNMPObjectAt(1);
        msgFlags = header.getSNMPObjectAt(2);
        msgSecurityModel = header.getSNMPObjectAt(3);
        if (requestMsgID != Integer.parseInt(msgID.getValue().toString())) {
            SnmpV3MsgID requestIDIns = SnmpV3MsgIDManager.getInstance().getMsgIDInstance(Integer.toString(requestMsgID));
            SnmpV3MsgID receiveIDIns = SnmpV3MsgIDManager.getInstance().getMsgIDInstance(msgID.getValue().toString());
            String requestMsg = " Request Thread Name=" + requestIDIns.getThreadName() + "(" + Thread.currentThread().getName() + ")" + " OID=" + requestIDIns.getOid();
            String receiveMsg = " Receive Thread Name=" + receiveIDIns.getThreadName() + " OID=" + receiveIDIns.getOid();
            AlarmMessageMake message = AlarmMessageMake.getInstance();
            message.setErrorSNMPV3UnmuchRequestMsgID(this.targetAddress.getHostAddress(), requestMsgID, msgID.getValue().toString(), " Get OID=" + requestOID + requestMsg + receiveMsg);
            SnmpStatisticsManager.getInstance().addSnmpV3UnmuchMsgID(this.targetAddress.getHostAddress());
            logger.warning("Unmuch msgID, requestMsgID=" + requestMsgID + " receive msgID=" + msgID.getValue());
            throw new SnmpUnmuchRequestMsgIDException("Unmuch msgID, requestMsgID=" + requestMsgID + " receive msgID=" + msgID.getValue());
        }
        try {
            receiveMsgFlags = Integer.parseInt(msgFlags.toString());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Illegal msgFlags : " + receiveMsgFlags);
        }
        SnmpOctetString securityParaOctet = (SnmpOctetString)request.getSNMPObjectAt(2);
        SnmpSequence securityPara = null;
        try {
            securityPara = new SnmpSequence((byte[])securityParaOctet.getValue());
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
        SnmpSequence securityParasSequence = (SnmpSequence)securityPara.getSNMPObjectAt(0);
        msgAuthoritativeEngineID = securityParasSequence.getSNMPObjectAt(0);
        msgAuthoritativeBoots = securityParasSequence.getSNMPObjectAt(1);
        msgAuthoritativeEngineTime = securityParasSequence.getSNMPObjectAt(2);
        msgUserName = securityParasSequence.getSNMPObjectAt(3);
        logger.info("Receive version : " + msgVersion.getValue());
        logger.info("Receive msgID : " + msgID.getValue());
        logger.info("Receive msgMaxSize : " + msgMaxSize.getValue());
        logger.info("Receive msgFlags : " + msgFlags);
        logger.info("Receive msgSecurityModel : " + msgSecurityModel.getValue());
        logger.info("Receive msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        logger.info("Receive msgAuthoritativeBoots : " + msgAuthoritativeBoots.getValue());
        logger.info("Receive msgAuthoritativeEngineTime : " + msgAuthoritativeEngineTime.getValue());
        logger.info("Receive msgUserName : " + msgUserName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive version : " + msgVersion.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgID : " + msgID.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgMaxSize : " + msgMaxSize.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgFlags : " + msgFlags);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgSecurityModel : " + msgSecurityModel.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgAuthoritativeBoots : " + msgAuthoritativeBoots.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgAuthoritativeEngineTime : " + msgAuthoritativeEngineTime.getValue());
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive msgUserName : " + msgUserName);
        securityParasSequence.getSNMPObjectAt(4);
        AbstractSnmpObject msgPrivacyParameters = securityParasSequence.getSNMPObjectAt(5);
        UsmUserEntry usmUserEntry = null;
        snmpV3ConfigInformation = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(this.targetAddress.getHostAddress());
        if (snmpV3ConfigInformation.isLearned()) {
            HashMap snmpV3EngineIDList = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3ConfigEngineIDMapList();
            String checkSnmpEngineID = msgAuthoritativeEngineID.toString().substring(2);
            if (snmpV3EngineIDList.size() > 0) {
                snmpV3ConfigInformation = (SnmpV3ManagerConfigInfo)snmpV3EngineIDList.get(checkSnmpEngineID);
            }
            userConfigInfo = (SnmpV3ManagerUserConfigInfo)snmpV3ConfigInformation.getUserList().get(0);
            if (snmpV3ConfigInformation == null) {
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Not found engineID = " + checkSnmpEngineID);
                throw new SnmpV3AuthAbortException("Not found engineID = " + checkSnmpEngineID);
            }
            logger.info("EngineID much config Agent IP Address = " + snmpV3ConfigInformation.getIpAddress());
            logger.info("EngineID much config User Name = " + userConfigInfo.getUsername());
            String userName = userConfigInfo.getUsername();
            if (!userName.equals(msgUserName.toString())) {
                logger.warning("Unmuch userName at receive data=" + msgUserName + " config userName=" + userName);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Unmuch userName at receive data=" + msgUserName + " config userName=" + userName);
                throw new SnmpV3AuthAbortException("Unmuch userName=" + msgUserName);
            }
            usmUserEntry = UsmUserManager.getInstance().getUsmUserEntry(new SnmpEngineID(checkSnmpEngineID), userName);
            if (usmUserEntry == null) {
                logger.warning("Not found USMUser Entry at snmpEngineID : " + checkSnmpEngineID + " and " + "userName : " + userName);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Not found USMUser Entry at snmpEngineID : " + checkSnmpEngineID + " and " + "userName : " + userName);
                throw new SnmpV3AuthAbortException("Not found USMUser Entry at snmpEngineID : " + checkSnmpEngineID + " and " + "userName : " + userName);
            }
            String authPriv = userConfigInfo.getAuthPriv();
            if (authPriv.equals("NOAUTH")) {
                if ((receiveMsgFlags & 3) != 0) {
                    logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
                }
            } else if (authPriv.equals("AUTH")) {
                if ((receiveMsgFlags & 1) != 1) {
                    logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
                }
            } else if (authPriv.equals("PRIV") && (receiveMsgFlags & 2) != 2) {
                logger.warning("Unmuch msgFlags : " + receiveMsgFlags);
            }
        } else {
            String checkSnmpEngineID = msgAuthoritativeEngineID.toString().substring(2);
            logger.info("usmUserEntry1 : SnmpEngineID : " + checkSnmpEngineID + " userName :" + msgUserName.toString());
            usmUserEntry = UsmUserManager.getInstance().getUsmUserEntry(new SnmpEngineID(checkSnmpEngineID), msgUserName.toString());
        }
        boolean isCheckAuth = false;
        if ((receiveMsgFlags & 1) == 1) {
            try {
                isCheckAuth = UsmSecuritySubsystem.getInstance().checkAuth(request, securityParasSequence, usmUserEntry.getUsmUserAuthKey());
            }
            catch (GeneralSecurityException e4) {
                logger.warning(e4.getMessage());
                logger.warning("Auth error Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Auth error Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID);
                e4.printStackTrace();
                throw e4;
            }
            if (!isCheckAuth) {
                logger.warning("Auth error Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID);
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Auth error Target IP=" + this.targetAddress.getHostAddress() + " OID=" + requestOID);
                throw new SnmpV3AuthAbortException();
            }
        }
        SnmpSequence scopedPDUData = null;
        SnmpOctetString descyptOctetData = null;
        if ((receiveMsgFlags & 2) == 2) {
            try {
                if (!(request.getSNMPObjectAt(3) instanceof SnmpOctetString)) {
                    if (request.getSNMPObjectAt(3) instanceof SnmpSequence) {
                        SnmpSequence testDescyptOctetData = (SnmpSequence)request.getSNMPObjectAt(3);
                        if (testDescyptOctetData.getSNMPObjectAt(2) instanceof SnmpSequence) {
                            scopedPDUData = (SnmpSequence)request.getSNMPObjectAt(3);
                        } else {
                            descyptOctetData = (SnmpOctetString)testDescyptOctetData.getSNMPObjectAt(0);
                            logger.warning("Not report PDU");
                            descyptOctetData = (SnmpOctetString)testDescyptOctetData.getSNMPObjectAt(1);
                        }
                    }
                } else {
                    descyptOctetData = (SnmpOctetString)request.getSNMPObjectAt(3);
                }
                if (descyptOctetData != null && descyptOctetData.getValue() != null) {
                    if (msgPrivacyParameters == null || msgPrivacyParameters.getValue() == null) {
                        logger.warning("msgPrivacyParameters null");
                    }
                    SnmpSequence scopedPDUDataWork = null;
                    scopedPDUDataWork = UsmSecuritySubsystem.getInstance().decrypt((byte[])descyptOctetData.getValue(), (byte[])msgPrivacyParameters.getValue(), usmUserEntry.getUsmUserPrivKey());
                    if (scopedPDUDataWork != null) {
                        try {
                            scopedPDUData = (SnmpSequence)scopedPDUDataWork.getSNMPObjectAt(0);
                        }
                        catch (Exception exception) {
                            logger.warning("Asemble SNMPSequence error by scopedPDU decrypt error");
                            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Asemble SNMPSequence error by scopedPDU decrypt error");
                            throw new SnmpV3DecryptAbortException("Asemble SNMPSequence error by scopedPDU decrypt error");
                        }
                    } else {
                        logger.warning("scopedPDU decrypt error");
                    }
                    if (scopedPDUData == null) {
                        logger.warning("ScopedPDU decrypt error");
                        logger.warning("usmStatsDecryptionErrors");
                        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("ScopedPDU decrypt error");
                        throw new SnmpV3DecryptAbortException("Asemble SNMPSequence error by scopedPDU decrypt error");
                    }
                }
            }
            catch (GeneralSecurityException e3) {
                logger.warning(e3.getMessage());
                SnmpManagerQueue.getInstance().pushSnmpManagerQueue(e3.getMessage());
                e3.printStackTrace();
            }
        } else {
            scopedPDUData = (SnmpSequence)request.getSNMPObjectAt(3);
        }
        if (scopedPDUData == null) {
            logger.warning("Scoped PDU Data null");
            SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Scoped PDU Data null");
            throw new SnmpV3DecryptAbortException("Decrypt error");
        }
        AbstractSnmpObject contextEngineID = scopedPDUData.getSNMPObjectAt(0);
        AbstractSnmpObject contextName = scopedPDUData.getSNMPObjectAt(1);
        AbstractSnmpObject pduData = scopedPDUData.getSNMPObjectAt(2);
        logger.info("Receive contextEngineID : " + contextEngineID);
        logger.info("Receive contextName : " + contextName);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive contextEngineID : " + contextEngineID);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Receive contextName : " + contextName);
        SnmpPDU pduTLV = null;
        SnmpSequence pduTLVSequence = null;
        try {
            pduTLVSequence = new SnmpSequence(pduData.getBEREncoding());
        }
        catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }
        pduTLV = (SnmpPDU)pduTLVSequence.getSNMPObjectAt(0);
        Date date = Calendar.getInstance().getTime();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Scoped PDU Receive Date : " + this.simpleDateformat.format(date) + " : ");
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(this.hexBytetoString(pduTLV.getBEREncoding(), pduTLV.getBEREncoding().length));
        this.messageReceiveInstance.setSnmpReceiveSocket(this.targetAddress, this.dSocket);
        SnmpVarBindList retrievedVars = this.messageReceiveInstance.parsePDU(pduTLV, requestID, requestOID);
        receiveMessageInfo.setMsgVersion(Integer.parseInt(msgVersion.toString()));
        receiveMessageInfo.setMsgID(Integer.parseInt(msgID.toString()));
        receiveMessageInfo.setMsgMaxSize(Integer.parseInt(msgMaxSize.toString()));
        receiveMessageInfo.setMsgFlags(msgFlags.toString());
        receiveMessageInfo.setMsgSecurityModel(Integer.parseInt(msgSecurityModel.toString()));
        receiveMessageInfo.setMsgAuthoritativeEngineID(msgAuthoritativeEngineID.toString());
        receiveMessageInfo.setMsgAuthoritativeBoots(Integer.parseInt(msgAuthoritativeBoots.toString()));
        receiveMessageInfo.setMsgAuthoritativeEngineTime(Integer.parseInt(msgAuthoritativeEngineTime.toString()));
        receiveMessageInfo.setMsgUserName(msgUserName.toString());
        receiveMessageInfo.setRetrievedVars(retrievedVars);
        return receiveMessageInfo;
    }

    public SnmpSequence createSNMPV3Message(int msgID, SnmpV3ManagerConfigInfo info, String userName, int requestID, String requestOID, byte code, AbstractSnmpObject newVar) throws GeneralSecurityException, SnmpV3ConfigurationException {
        SnmpSequence sendSNMPSequence;
        block22: {
            int snmpVersion = 3;
            int securityModel = 3;
            SnmpEngineID snmpEngineID = new SnmpEngineID(info.getSnmpEngineID());
            int snmpEngineBoots = Integer.parseInt(info.getSnmpEngineBoots());
            long agentStartTime = Long.parseLong(info.getSnmpEngineTime());
            String contextName = info.getContextName();
            sendSNMPSequence = new SnmpSequence();
            try {
                UsmUserEntry usmUserEntry = UsmUserManager.getInstance().getUsmUserEntry(snmpEngineID, userName);
                if (usmUserEntry == null) {
                    logger.warning("Not user entry");
                    logger.warning("snmpEngineID : " + snmpEngineID);
                    logger.warning("userName : " + userName);
                    throw new SnmpV3ConfigurationException(String.valueOf(userName) + "@" + snmpEngineID + " Not user entry");
                }
                this.authFlag = usmUserEntry.getUsmUserAuthProtocol() != UsmUserEntry.USM_NO_AUTH_PROTOCOL;
                this.privFlag = usmUserEntry.getUsmUserPrivProtocol() != UsmUserEntry.USM_NO_PRIV_PROTOCOL;
                sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
                SnmpSequence msgGlobalData = new SnmpSequence();
                msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
                msgGlobalData.addSNMPObject(new SnmpInteger(1472L));
                byte msgFlag = 4;
                if (this.authFlag) {
                    msgFlag = (byte)(msgFlag | 1);
                }
                if (this.privFlag) {
                    msgFlag = (byte)(msgFlag | 2);
                }
                msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
                msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
                sendSNMPSequence.addSNMPObject(msgGlobalData);
                SnmpSequence msgSecurityParameters = new SnmpSequence();
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
                int snmpEngineTime = (int)((System.currentTimeMillis() - agentStartTime) / 1000L);
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(usmUserEntry.getUsmUserName()));
                if (this.authFlag) {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[12]));
                } else {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                byte[] iv = null;
                if (this.privFlag) {
                    logger.info("Priv");
                    iv = UsmSecuritySubsystem.getInstance().getIV(snmpEngineBoots);
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.getInstance().getSalt(usmUserEntry.getUsmUserPrivKey(), iv)));
                } else {
                    logger.info("NoPriv");
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
                SnmpSequence msgData = new SnmpSequence();
                msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgData.addSNMPObject(new SnmpOctetString(contextName));
                SnmpPDU sendPDU = null;
                try {
                    switch (code) {
                        case -95: {
                            sendPDU = this.createSNMPPDU(requestID, requestOID, code, newVar);
                            break;
                        }
                        case -93: {
                            sendPDU = this.createSNMPPDU(requestID, requestOID, code, newVar);
                            break;
                        }
                        default: {
                            logger.warning("Illegal code=" + Byte.toString(code));
                            break;
                        }
                    }
                }
                catch (SnmpBadValueException e3) {
                    logger.warning("create snmp V3 message : " + e3.getMessage());
                    e3.printStackTrace();
                    throw e3;
                }
                msgData.addSNMPObject(sendPDU);
                if (this.privFlag) {
                    logger.info("Priv");
                    try {
                        sendSNMPSequence.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.encrypt(msgData, iv, usmUserEntry.getUsmUserPrivKey())));
                    }
                    catch (GeneralSecurityException e2) {
                        logger.warning(e2.getMessage());
                        e2.printStackTrace();
                        throw e2;
                    }
                } else {
                    logger.info("No Priv");
                    sendSNMPSequence.addSNMPObject(msgData);
                }
                if (this.authFlag) {
                    logger.info("Auth");
                    try {
                        SnmpOctetString msgAuthenticationParametersOctet = null;
                        msgAuthenticationParametersOctet = UsmSecuritySubsystem.getInstance().setAuth(sendSNMPSequence, msgSecurityParameters, usmUserEntry.getUsmUserAuthKey());
                        logger.info("usmUserName : " + usmUserEntry.getUsmUserName());
                        logger.info("usmUserAuthProtocol : " + usmUserEntry.getUsmUserAuthProtocol());
                        logger.info("usmUserAuthKey : " + this.hexBytetoString(usmUserEntry.getUsmUserAuthKey().getEncoded(), usmUserEntry.getUsmUserAuthKey().getEncoded().length));
                        msgSecurityParameters.addSNMPObject(msgAuthenticationParametersOctet, 4);
                    }
                    catch (GeneralSecurityException e2) {
                        logger.warning(e2.getMessage());
                        e2.printStackTrace();
                        throw e2;
                    }
                    sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()), 2);
                    break block22;
                }
                logger.info("No Auth");
            }
            catch (SnmpBadValueException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        return sendSNMPSequence;
    }

    private SnmpPDU createSNMPPDU(int requestID, String requestOID, byte code, AbstractSnmpObject newVar) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;
        byte pduType = code;
        SnmpPDU pdu = null;
        try {
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(requestOID);
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, newVar);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            pdu = new SnmpPDU(pduType, requestID, errorStatus, errorIndex, varList);
        }
        catch (SnmpBadValueException e) {
            e.printStackTrace();
            throw new SnmpBadValueException(String.valueOf(requestOID) + " : " + e.getMessage());
        }
        return pdu;
    }
}

