/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.socket;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AuthenticationInfo;

public abstract class AbstractConnectionEngine {
    private static Logger logger = null;
    protected String engineServerAddress;
    protected int enginePort;
    protected int socketTimeout;
    protected AuthenticationInfo authInfo;
    protected String userName;
    protected String password;

    public AbstractConnectionEngine(String engineAddress) {
        String checkAddress;
        logger = Logger.getLogger(this.getClass().getName());
        this.engineServerAddress = engineAddress;
        String socketTimeoutString = "0";
        ArrayList engineList = EngineResourceConfig.getInstance().getEngineInfo().getEngineInfoList();
        String enginePortString = "";
        boolean isMuchEngineAddress = false;
        int i = 0;
        while (i < engineList.size()) {
            checkAddress = ((EngineResourceInfo)engineList.get(i)).getEngineIPaddress();
            if (engineAddress.equals(checkAddress)) {
                enginePortString = ((EngineResourceInfo)engineList.get(i)).getEnginePort();
                socketTimeoutString = ((EngineResourceInfo)engineList.get(i)).getEngineTimeout();
                this.userName = ((EngineResourceInfo)engineList.get(i)).getUserName();
                this.password = ((EngineResourceInfo)engineList.get(i)).getPassword();
                isMuchEngineAddress = true;
                break;
            }
            ++i;
        }
        if (!isMuchEngineAddress) {
            i = 0;
            while (i < engineList.size()) {
                checkAddress = ((EngineResourceInfo)engineList.get(i)).getEngineIPaddress();
                if (checkAddress.equals("127.0.0.1")) {
                    String checkLocalEngineAddress = "";
                    try {
                        checkLocalEngineAddress = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    if (engineAddress.equals(checkLocalEngineAddress)) {
                        enginePortString = ((EngineResourceInfo)engineList.get(i)).getEnginePort();
                        socketTimeoutString = ((EngineResourceInfo)engineList.get(i)).getEngineTimeout();
                        this.userName = ((EngineResourceInfo)engineList.get(i)).getUserName();
                        this.password = ((EngineResourceInfo)engineList.get(i)).getPassword();
                        isMuchEngineAddress = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (isMuchEngineAddress) {
            try {
                this.authInfo = new AuthenticationInfo();
                this.authInfo.setUserName(this.userName);
                this.authInfo.setPassword(this.password);
                this.enginePort = Integer.parseInt(enginePortString);
                this.socketTimeout = Integer.parseInt(socketTimeoutString);
            }
            catch (NumberFormatException e) {
                logger.warning("Engine port NumberFormatException");
                logger.warning("Engine address : " + engineAddress);
                logger.warning("Engine port : " + enginePortString);
                logger.warning("Engine timeout : " + socketTimeoutString);
                e.printStackTrace();
            }
        } else {
            logger.warning("Not found Engine address : " + engineAddress);
        }
    }

    public Object communicationToEngine(CommandInfo commandInfo) throws EngineConnectException, IOException {
        commandInfo.setAuthInfo(this.authInfo);
        Object responseObject = null;
        Socket socket = null;
        ObjectOutputStream oos = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            InetAddress dstInetAddr = InetAddress.getByName(this.engineServerAddress);
            socket = new Socket(dstInetAddr, this.enginePort);
            socket.setSoTimeout(this.socketTimeout);
            OutputStream os = socket.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(commandInfo);
            oos.flush();
            bis = new BufferedInputStream(socket.getInputStream());
            ois = new ObjectInputStream(bis);
            try {
                responseObject = ois.readObject();
            }
            catch (EOFException ex) {
                logger.warning(ex.getMessage());
                ex.printStackTrace();
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                }
                return null;
            }
            try {
                if (responseObject instanceof CommandInfo) {
                    if (((CommandInfo)responseObject).getCode().equals("NACK")) {
                        throw new EngineConnectException("Nack receive");
                    }
                    if (((CommandInfo)responseObject).getCode().equals("AUTH")) {
                        throw new EngineConnectException("Authentication error");
                    }
                }
                CommandInfo ackCommnadInfo = new CommandInfo();
                ackCommnadInfo.setCode("ACK");
                oos.writeObject(ackCommnadInfo);
                oos.flush();
            }
            catch (UnknownHostException ex) {
                logger.warning("Client communication UnknownHostException");
                throw new EngineConnectException(String.valueOf(ex.getMessage()) + " Engine address = " + this.engineServerAddress + " port = " + this.enginePort);
            }
            catch (ConnectException e) {
                logger.warning("ConnectException : " + e.getMessage());
                throw new EngineConnectException(String.valueOf(e.getMessage()) + " Engine address = " + this.engineServerAddress + " port = " + this.enginePort);
            }
            catch (ClassNotFoundException ex) {
                logger.warning("Client communication ClassNotFoundException");
                throw new EngineConnectException(String.valueOf(ex.getMessage()) + " Engine address = " + this.engineServerAddress + " port = " + this.enginePort);
            }
            catch (SocketTimeoutException ex) {
                logger.warning("Client communication SocketTimeoutException " + ex.getMessage() + " SoTimeout=" + socket.getSoTimeout());
                throw ex;
            }
            catch (IOException ex) {
                logger.warning("Client communication IOException " + ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
        return responseObject;
    }
}

