/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.engine.socket.AbstractConnectionEngine;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.MibInfo;

public class ConnectionStatisticsMibSet
extends AbstractConnectionEngine {
    private static Logger logger;

    public ConnectionStatisticsMibSet(String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setStatisticsMibSet(String nodeIPAddress, MibInfo mibInfo) throws EngineConnectException, IOException {
        logger.info("Node Address=" + nodeIPAddress + " OID=" + mibInfo.getRequestMibOid());
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setCode("Statistics Mib Set");
        commnadInfo.setIpaddress(nodeIPAddress);
        commnadInfo.setMibInfo(mibInfo);
        this.communicationToEngine(commnadInfo);
    }

    public void editStatisticsMibSet(String nodeIPAddress, MibInfo mibInfo) throws EngineConnectException, IOException {
        logger.info("Node Address=" + nodeIPAddress + " OID=" + mibInfo.getRequestMibOid());
        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setCode("Statistics Mib Edit");
        commnadInfo.setIpaddress(nodeIPAddress);
        commnadInfo.setMibInfo(mibInfo);
        this.communicationToEngine(commnadInfo);
    }

    public void deleteStatisticsMibSet(String nodeIPAddress, MibInfo mibInfo) throws EngineConnectException, IOException {
        logger.info("Node Address=" + nodeIPAddress + " OID=" + mibInfo.getRequestMibOid());
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode("Statistics Mib Delete");
        commandInfo.setIpaddress(nodeIPAddress);
        commandInfo.setMibInfo(mibInfo);
        this.communicationToEngine(commandInfo);
    }
}

