/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpUnknownObject
extends AbstractSnmpObject {
    private byte[] data;

    public SnmpUnknownObject(byte[] enc) {
        this.data = enc;
        this.tag = 0;
        this.tagDescription = "UNKNOWNOBJECT";
    }

    public Object getValue() {
        return this.data;
    }

    public void setValue(Object data) throws SnmpBadValueException {
        if (!(data instanceof byte[])) {
            throw new SnmpBadValueException(" Unknown Object: bad object supplied to set value ");
        }
        this.data = (byte[])data;
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            int type = 0;
            byte[] len = this.encodeLength(this.data.length);
            outBytes.write(type);
            outBytes.write(len, 0, len.length);
            outBytes.write(this.data, 0, this.data.length);
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    public String toString() {
        return new String(this.data);
    }
}

