/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpv3;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3OID;
import netjfwatcher.snmp.snmpv3.UsmLocalizeKey;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;

public final class UsmUserManager {
    public static final String AUTHPRIV_NOAUTH = "NOAUTH";
    public static final String AUTHPRIV_AUTH = "AUTH";
    public static final String AUTHPRIV_PRIV = "PRIV";
    public static final String MSG_DIGEST_MD5 = "MD5";
    public static final String MSG_DIGEST_SHA1 = "SHA-1";
    public static final String CIPHER_DES = "DES";
    public static final String AUTH_PROTOCOL_MD5 = "MD5";
    public static final String AUTH_PROTOCOL_SHA = "SHA";
    public static final String PRIV_PROTOCOL_DES = "DES";
    private static Logger logger;
    private Map userEntryList = Collections.synchronizedMap(new Hashtable());
    private List usmUserEntryList = Collections.synchronizedList(new ArrayList());

    private UsmUserManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static UsmUserManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void testUsmUserEntry(String userName, String snmpEngineID, UsmUserEntry usmUserEntry) {
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID);
        if (this.userEntryList.containsKey(sb.toString())) {
            this.userEntryList.put(sb.toString(), usmUserEntry);
            this.usmUserEntryList.add(usmUserEntry);
        } else {
            logger.warning("Notfound Regist userName : " + sb.toString());
        }
    }

    public synchronized void registList(SnmpEngineID snmpEngineID, SnmpV3ManagerConfigInfo info) throws SnmpV3ConfigurationException {
        String userName = null;
        String authPriv = null;
        String authProtocol = null;
        String authPassPhrase = null;
        String privProtocol = null;
        String privPassPhrase = null;
        if (info == null || (SnmpV3ManagerUserConfigInfo)info.getUserList().get(0) == null) {
            logger.warning("SnmpV3 Manager Config undefined");
            throw new SnmpV3ConfigurationException("SnmpV3 Manager Config undefined");
        }
        userName = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getUsername();
        authPriv = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getAuthPriv();
        authProtocol = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getAuthProtocol();
        authPassPhrase = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getAuthPassPhrase();
        privProtocol = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getPrivProtocol();
        privPassPhrase = ((SnmpV3ManagerUserConfigInfo)info.getUserList().get(0)).getPrivPassPhrase();
        if (authPriv == null) {
            logger.warning("AuthPriv undefined");
            throw new SnmpV3ConfigurationException("AuthPriv undefined");
        }
        boolean error = false;
        if (userName == null || authPriv == null) {
            error = true;
        }
        if (authPriv.equals(AUTHPRIV_NOAUTH)) {
            authProtocol = null;
            privProtocol = null;
        } else if (authPriv.equals(AUTHPRIV_AUTH)) {
            privProtocol = null;
            if (authProtocol == null || !authProtocol.equals("MD5") && !authProtocol.equals(AUTH_PROTOCOL_SHA)) {
                error = true;
            }
            if (authPassPhrase == null) {
                error = true;
            }
        } else if (authPriv.equals(AUTHPRIV_PRIV)) {
            if (privProtocol == null || !privProtocol.equals("DES")) {
                error = true;
            }
            if (privPassPhrase == null) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            logger.warning("AuthPriv undefined");
            throw new SnmpV3ConfigurationException("AuthPriv undefined");
        }
        UsmUserEntry usmUserEntry = new UsmUserEntry();
        usmUserEntry.setUsmUserEngineID(snmpEngineID);
        usmUserEntry.setUsmUserName(userName);
        usmUserEntry.setUsmUserSecurityName(userName);
        usmUserEntry.setUsmUserCloneFrom(SnmpV3OID.ZERO_DOT_ZERO);
        try {
            if (authProtocol == null) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_NO_AUTH_PROTOCOL);
            } else if (authProtocol.equals("MD5")) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_HMAC_MD5_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(new UsmLocalizeKey(authPassPhrase, snmpEngineID, "HmacMD5"));
            } else if (authProtocol.equals(AUTH_PROTOCOL_SHA)) {
                usmUserEntry.setUsmUserAuthProtocol(UsmUserEntry.USM_HMAC_SHA_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(new UsmLocalizeKey(authPassPhrase, snmpEngineID, "HmacSHA1"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }
        usmUserEntry.setUsmUserAuthKeyChange("");
        usmUserEntry.setUsmUserOwnAuthKeyChange("");
        try {
            if (privProtocol == null) {
                usmUserEntry.setUsmUserPrivProtocol(UsmUserEntry.USM_NO_PRIV_PROTOCOL);
            } else if (privProtocol.equals("DES")) {
                usmUserEntry.setUsmUserPrivProtocol(UsmUserEntry.USM_DES_PRIV_PROTOCOL);
                if (authProtocol.equals("MD5")) {
                    usmUserEntry.setUsmUserPrivKey(new UsmLocalizeKey(privPassPhrase, snmpEngineID, "HmacMD5"));
                } else if (authProtocol.equals(AUTH_PROTOCOL_SHA)) {
                    usmUserEntry.setUsmUserPrivKey(new UsmLocalizeKey(privPassPhrase, snmpEngineID, "HmacSHA1"));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning(e.getMessage());
            throw new SnmpV3ConfigurationException(e.getMessage());
        }
        usmUserEntry.setUsmUserPrivKeyChange("");
        usmUserEntry.setUsmUserOwnPrivKeyChange("");
        usmUserEntry.setUsmUserPublic("");
        usmUserEntry.setUsmUserStorageType(2L);
        usmUserEntry.setUsmUserStatus(1L);
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());
        this.userEntryList.put(sb.toString(), usmUserEntry);
        this.usmUserEntryList.add(usmUserEntry);
    }

    public UsmUserEntry getUsmUserEntry(SnmpEngineID snmpEngineID, String userName) {
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());
        return (UsmUserEntry)this.userEntryList.get(sb.toString());
    }

    public UsmUserEntry getUsmUserEntry(int n) {
        if (n < 0 || n >= this.usmUserEntryList.size()) {
            return null;
        }
        return (UsmUserEntry)this.usmUserEntryList.get(n);
    }

    /* synthetic */ UsmUserManager(UsmUserManager usmUserManager) {
        this();
    }

    private static class SingletonResource {
        static final UsmUserManager RESOURCE = new UsmUserManager(null);

        private SingletonResource() {
        }
    }
}

