/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;
import netjfwatcher.snmpagent.process.AbstractAgentMessageProcessing;
import netjfwatcher.snmpagent.process.AgentSysupTime;
import netjfwatcher.snmpagent.process.AgentV1MP;
import netjfwatcher.snmpagent.process.AgentV2MP;
import netjfwatcher.snmpagent.process.AgentV3MP;

public class AgentDispatcher {
    private static Logger logger;
    private DatagramSocket dSocket;
    private DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
    private String snmpVersionDesc = "";
    private String snmpCommandCodeDesc = "";

    public AgentDispatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public AgentDispatcher(DatagramSocket dSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.dSocket = dSocket;
    }

    public void dispacherTrapSend(String targetAddress, int version, String community, SnmpSequence pdu) throws GeneralSecurityException, UnknownHostException, SnmpV3ConfigurationException, SnmpBadValueException, SocketException, IOException {
        logger.info("Version : " + version);
        logger.info("Community : " + community);
        AbstractAgentMessageProcessing mp = null;
        switch (version) {
            case 0: {
                mp = new AgentV1MP();
                break;
            }
            case 1: {
                mp = new AgentV2MP();
                break;
            }
            case 3: {
                mp = new AgentV3MP();
                break;
            }
            default: {
                logger.warning("Illegal Trap send version : " + version);
            }
        }
        mp.sendTrap(targetAddress, community, pdu);
    }

    public void dispath(DatagramPacket inPacket, byte[] encodedMessage, int receiveLength) throws GeneralSecurityException, SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        Date date = Calendar.getInstance().getTime();
        AgentMonitorMessageQueue.getInstance().pushAgentMessage("Receive date : " + this.dateformat.format(date) + " : Data length : " + receiveLength + "Byte");
        AgentMonitorMessageQueue.getInstance().pushAgentMessage(this.hexBytetoString(encodedMessage, receiveLength));
        byte receiveSnmpVersionDispatch = 0;
        SnmpMessage receivedMessage = null;
        AbstractAgentMessageProcessing mp = null;
        try {
            receivedMessage = new SnmpMessage();
            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);
            byte[] versionByte = receivedMessage.getVersion();
            receiveSnmpVersionDispatch = versionByte[0];
            this.setSnmpVersion(receiveSnmpVersionDispatch);
            logger.info("Version : " + receiveSnmpVersionDispatch + "(" + this.snmpVersionDesc + ")");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Version : " + receiveSnmpVersionDispatch + " (" + this.snmpVersionDesc + ")");
            if (receiveSnmpVersionDispatch != 3) {
                byte command = receivedMessage.getCommand();
                this.setCommandLog(command);
                byte[] communityByte = receivedMessage.getCommunity();
                logger.info("Community : " + this.bytetoChar(communityByte));
                logger.info("Command : " + this.hexByte(command) + " (" + this.snmpCommandCodeDesc + ")");
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Community : " + this.bytetoChar(communityByte));
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Command : " + this.hexByte(command) + " (" + this.snmpCommandCodeDesc + ")");
            }
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        switch (receiveSnmpVersionDispatch) {
            case 0: {
                mp = new AgentV1MP(this.dSocket);
                break;
            }
            case 1: {
                mp = new AgentV2MP(this.dSocket);
                break;
            }
            case 3: {
                mp = new AgentV3MP(this.dSocket);
                break;
            }
            default: {
                logger.warning("Undefined command");
            }
        }
        try {
            AgentSysupTime.getInstance().updateSysupTime();
            mp.process(inPacket, encodedMessage, receiveLength);
        }
        catch (SnmpErrorStatusException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Receive data error status not correct : " + this.dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(this.hexBytetoString(encodedMessage, receiveLength));
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Abort create response data : " + this.dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(this.hexBytetoString(encodedMessage, receiveLength));
            throw e1;
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Abort send data to  : " + this.dateformat.format(date));
            throw e1;
        }
    }

    private void setCommandLog(byte code) {
        switch (code) {
            case -96: {
                this.snmpCommandCodeDesc = "GetRequest";
                break;
            }
            case -95: {
                this.snmpCommandCodeDesc = "GetNextRequest";
                break;
            }
            case -93: {
                this.snmpCommandCodeDesc = "SetRequest";
                break;
            }
            default: {
                this.snmpCommandCodeDesc = "Unknown";
                logger.warning("Undefined SNMP Command code : " + code);
                return;
            }
        }
    }

    private void setSnmpVersion(int version) {
        switch (version) {
            case 0: {
                this.snmpVersionDesc = "SNMPV1";
                break;
            }
            case 1: {
                this.snmpVersionDesc = "SNMPV2C";
                break;
            }
            case 3: {
                this.snmpVersionDesc = "SNMPV3";
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
                return;
            }
        }
    }

    public String hexBytetoString(byte[] byteData, int receiveLength) {
        StringBuffer returnString = new StringBuffer();
        int i = 0;
        while (byteData.length > i && receiveLength > i) {
            int pos;
            if (i != 0 && i % 16 == 0) {
                returnString.append(System.getProperty("line.separator"));
            }
            if ((pos = byteData[i]) < 0) {
                pos += 256;
            }
            returnString.append(Integer.toHexString(pos / 16));
            returnString.append(String.valueOf(Integer.toHexString(pos % 16)) + " ");
            ++i;
        }
        return returnString.toString();
    }

    public String hexByte(byte byteData) {
        String returnString = "";
        int pos = byteData;
        if (pos < 0) {
            pos += 256;
        }
        returnString = String.valueOf(returnString) + Integer.toHexString(pos / 16);
        returnString = String.valueOf(returnString) + Integer.toHexString(pos % 16);
        return returnString;
    }

    public String bytetoChar(byte[] byteData) {
        String returnString = "";
        int i = 0;
        while (i < byteData.length) {
            returnString = String.valueOf(returnString) + (char)byteData[i];
            ++i;
        }
        return returnString;
    }
}

