/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.process.AbstractAgentMessageProcessing;

public class AgentV2MP
extends AbstractAgentMessageProcessing {
    private static Logger logger;
    private static SnmpAgentConfigInfo info;

    public AgentV2MP() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 1;
    }

    public AgentV2MP(DatagramSocket dSocket) throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 1;
        info = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpAgentResourceInfo();
        this.resSendDatagramSocket = dSocket;
    }

    public void process(DatagramPacket inPacket, byte[] encodedMessage, int receiveLength) throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        this.inPacket = inPacket;
        byte command = 0;
        String community = "";
        SnmpMessage receivedMessage = null;
        try {
            receivedMessage = new SnmpMessage();
            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);
            byte[] versionByte = receivedMessage.getVersion();
            byte[] communityByte = receivedMessage.getCommunity();
            community = this.bytetoChar(communityByte);
            command = receivedMessage.getCommand();
            logger.info("Version : " + versionByte[0]);
            logger.info("Community : " + this.bytetoChar(communityByte));
            logger.info("Command : " + this.hexByte(command));
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            throw e;
        }
        this.receivedMessage = receivedMessage;
        switch (command) {
            case -96: {
                if (community.equals(info.getReadCommunity())) {
                    this.getRequest(this.version, info.getReadCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive read community : " + community + " Allow read community : " + info.getReadCommunity());
                break;
            }
            case -95: {
                if (community.equals(info.getReadCommunity())) {
                    this.getNextRequest(this.version, info.getReadCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive read community : " + community + " Allow read community : " + info.getReadCommunity());
                break;
            }
            case -93: {
                if (community.equals(info.getWriteCommunity())) {
                    this.setRequest(this.version, info.getWriteCommunity(), inPacket, receivedMessage);
                    break;
                }
                logger.warning("Receive write community : " + community + " Allow write community : " + info.getReadCommunity());
                break;
            }
            default: {
                logger.warning("Bad command : " + command);
            }
        }
    }

    public void sendTrap(String hostAddress, String community, SnmpSequence pdu) throws SnmpBadValueException, UnknownHostException, IOException {
        int requestID = 0;
        InetAddress targetAddress = null;
        try {
            targetAddress = InetAddress.getByName(hostAddress);
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        SnmpSequence message = null;
        if (!(pdu instanceof SnmpTrap2PDU)) {
            throw new SnmpBadValueException("Illegal Trap pdu");
        }
        message = this.createTrap2Message(requestID, community, (SnmpTrap2PDU)pdu);
        byte[] messageEncoding = message.getBEREncoding();
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, targetAddress, trapPort);
        this.trapDatagramSocket.send(outPacket);
    }

    public SnmpSequence createTrap2Message(int trapRequestID, String community, SnmpTrap2PDU pdu) {
        int snmpVersion = 1;
        SnmpSequence sendSNMPSequence = new SnmpSequence();
        int errorStatus = 0;
        int errorIndex = 0;
        sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
        sendSNMPSequence.addSNMPObject(new SnmpOctetString(community));
        pdu.setPDU(trapRequestID, errorStatus, errorIndex);
        sendSNMPSequence.addSNMPObject(pdu);
        return sendSNMPSequence;
    }
}

