/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserAgentManager;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;
import netjfwatcher.snmpagent.process.AbstractAgentMessageProcessing;
import netjfwatcher.snmpagent.process.AgentV3DiscoverySequence;
import netjfwatcher.snmpagent.process.AgentV3Report;
import netjfwatcher.snmpagent.process.ThreadAgent;
import netjfwatcher.snmptest.SnmpErrorTest;

public class AgentV3MP
extends AbstractAgentMessageProcessing {
    private static Logger logger;
    private static AbstractSnmpObject msgID;
    private static AbstractSnmpObject msgAuthoritativeEngineID;
    private AbstractSnmpObject msgAuthoritativeBoots;
    private AbstractSnmpObject msgAuthoritativeEngineTime;
    private UsmUserEntry usmUserEntry = null;
    private String authPriv;
    private boolean authFlag = false;
    private boolean privFlag = false;
    private SnmpV3AgentConfigInfo snmpV3AgentConfigInfo;
    private String snmpEngineID = "";
    private String receiveCheckEngineID = "";
    private long receiveCheckEngineTime = 0L;
    private String userName = "";
    private String receiveCheckUserName = "";
    private long receiveCheckBoots = 0L;
    private int receiveMsgID = 0;

    public AgentV3MP() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 3;
    }

    public AgentV3MP(DatagramSocket dSocket) throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = 3;
        this.resSendDatagramSocket = dSocket;
    }

    public void process(DatagramPacket inPacket, byte[] encodedMessage, int receiveLength) throws GeneralSecurityException, SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        this.inPacket = inPacket;
        int receiveMsgFlags = 0;
        SnmpMessage receivedMessage = null;
        AbstractSnmpObject msgVersion = null;
        AbstractSnmpObject msgMaxSixe = null;
        AbstractSnmpObject msgFlags = null;
        AbstractSnmpObject msgSecurityModel = null;
        AbstractSnmpObject msgUserName = null;
        AbstractSnmpObject msgAuthenticationParameters = null;
        AbstractSnmpObject msgPrivacyParameters = null;
        AbstractSnmpObject contextEngineID = null;
        AbstractSnmpObject contextName = null;
        SnmpSequence request = null;
        SnmpSequence securityParasSequence = null;
        try {
            receivedMessage = new SnmpMessage();
            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);
            request = new SnmpSequence();
            SNMPTLV nextTLV2 = request.extractNextTLV(encodedMessage, 0);
            try {
                request.setTLV(nextTLV2);
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                throw e;
            }
            msgVersion = request.getSNMPObjectAt(0);
            if (!(msgVersion instanceof SnmpInteger)) {
                logger.warning("Version is not INTEGER");
                throw new SnmpBadValueException("Version is not INTEGER");
            }
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgVersion : " + msgVersion.getValue());
            SnmpSequence header = (SnmpSequence)request.getSNMPObjectAt(1);
            msgID = header.getSNMPObjectAt(0);
            this.receiveMsgID = Integer.parseInt(msgID.toString());
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgID : " + msgID.getValue());
            msgMaxSixe = header.getSNMPObjectAt(1);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgMaxSixe : " + msgMaxSixe.getValue());
            msgFlags = header.getSNMPObjectAt(2);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgFlags : " + msgFlags);
            msgSecurityModel = header.getSNMPObjectAt(3);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgSecurityModel : " + msgSecurityModel.getValue());
            SnmpOctetString securityParaOctet = (SnmpOctetString)request.getSNMPObjectAt(2);
            SnmpSequence securityPara = null;
            try {
                securityPara = new SnmpSequence((byte[])securityParaOctet.getValue());
            }
            catch (SnmpBadValueException e) {
                logger.warning("Parse error at receive data : " + e.getMessage());
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Parse error at receive data : " + e.getMessage());
                throw e;
            }
            securityParasSequence = (SnmpSequence)securityPara.getSNMPObjectAt(0);
            msgAuthoritativeEngineID = securityParasSequence.getSNMPObjectAt(0);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
            if (msgAuthoritativeEngineID.toString().length() >= 2) {
                this.receiveCheckEngineID = msgAuthoritativeEngineID.toString().substring(2);
            }
            this.msgAuthoritativeBoots = securityParasSequence.getSNMPObjectAt(1);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgAuthoritativeBoots : " + this.msgAuthoritativeBoots);
            this.receiveCheckBoots = Long.parseLong(this.msgAuthoritativeBoots.toString());
            this.msgAuthoritativeEngineTime = securityParasSequence.getSNMPObjectAt(2);
            this.receiveCheckEngineTime = Long.parseLong(this.msgAuthoritativeEngineTime.toString());
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgAuthoritativeEngineTime : " + this.msgAuthoritativeEngineTime);
            msgUserName = securityParasSequence.getSNMPObjectAt(3);
            this.receiveCheckUserName = msgUserName.toString();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("msgUserName : " + msgUserName);
            msgAuthenticationParameters = securityParasSequence.getSNMPObjectAt(4);
            logger.info("msgVersion : " + msgVersion.getValue());
            logger.info("msgID : " + msgID.getValue());
            logger.info("msgMaxSixe : " + msgMaxSixe.getValue());
            logger.info("msgFlags : " + msgFlags);
            logger.info("msgSecurityModel : " + msgSecurityModel.getValue());
            logger.info("msgAuthoritativeEngineID : " + msgAuthoritativeEngineID);
            logger.info("msgAuthoritativeBoots : " + this.msgAuthoritativeBoots);
            logger.info("msgAuthoritativeEngineTime : " + this.msgAuthoritativeEngineTime);
            logger.info("msgUserName : " + msgUserName);
            if (securityParasSequence.size() > 5) {
                msgPrivacyParameters = securityParasSequence.getSNMPObjectAt(5);
            }
        }
        catch (SnmpBadValueException e) {
            logger.warning("Parse error of receive data : " + e.getMessage());
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Parse error of receive data : " + e.getMessage());
            throw e;
        }
        this.snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        this.snmpEngineID = this.snmpV3AgentConfigInfo.getSnmpEngineID();
        this.userName = this.snmpV3AgentConfigInfo.getUserName();
        this.authPriv = this.snmpV3AgentConfigInfo.getAuthPriv();
        logger.info("Agent authPriv config : " + this.authPriv);
        try {
            receiveMsgFlags = Integer.parseInt(msgFlags.toString());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Illegal msgFlags : " + msgFlags);
            logger.warning("Illegal msgFlags : " + msgFlags.getTagCode());
            logger.warning("Illegal msgFlags : " + msgFlags.getValue());
            throw new SnmpBadValueException("Illegal msgFlags : " + msgFlags);
        }
        this.authFlag = false;
        this.privFlag = false;
        this.authFlag = (receiveMsgFlags & 1) == 1;
        this.privFlag = (receiveMsgFlags & 2) == 2;
        if (receiveMsgFlags == 4 && ((byte[])msgAuthoritativeEngineID.getValue()).length <= 0) {
            logger.info("Discovey snmpEngineID");
        } else {
            if (msgAuthoritativeEngineID.toString().length() >= 2 && !this.snmpEngineID.equals(msgAuthoritativeEngineID.toString().substring(2))) {
                logger.warning("Unmuch EngineID Agent EngineID=" + this.snmpEngineID + "Receive EngineID=" + msgAuthoritativeEngineID);
                AgentMonitorMessageQueue.getInstance().pushAgentMessage("Unmuch EngineID Agent EngineID=" + this.snmpEngineID + "Receive EngineID=" + msgAuthoritativeEngineID);
                AgentV3Report report = new AgentV3Report();
                SnmpPDU reportPDU = report.sendUnknownEngineIDReport(this.receiveMsgID);
                this.sendReportPDU(inPacket, msgID.toString(), reportPDU);
                return;
            }
            if (this.authFlag) {
                this.usmUserEntry = UsmUserAgentManager.getInstance().getUsmUserEntry(new SnmpEngineID(this.snmpEngineID), this.userName);
                if (this.usmUserEntry == null) {
                    logger.warning("Notfound " + this.userName + "@" + this.snmpEngineID + " usmUserEntry");
                    logger.warning("Notfound " + this.receiveCheckUserName + "@" + msgAuthoritativeEngineID + " usmUserEntry");
                }
                boolean isCheckAuth = false;
                try {
                    isCheckAuth = UsmSecuritySubsystem.getInstance().checkAuth(request, securityParasSequence, this.usmUserEntry.getUsmUserAuthKey());
                    logger.info("snmpV3AgentConfigInfo.getAuthPassPhrase : " + this.snmpV3AgentConfigInfo.getAuthPassPhrase());
                    logger.info("Agent usmUserName : " + this.usmUserEntry.getUsmUserName());
                    logger.info("Agent usmUserAuthProtocol : " + this.usmUserEntry.getUsmUserAuthProtocol());
                    logger.info("Agent usmUserAuthKey : " + this.hexBytetoString(this.usmUserEntry.getUsmUserAuthKey().getEncoded(), this.usmUserEntry.getUsmUserAuthKey().getEncoded().length));
                }
                catch (GeneralSecurityException e) {
                    logger.warning(e.getMessage());
                    throw e;
                }
                if (isCheckAuth) {
                    logger.info("CheckAuth true : " + isCheckAuth);
                } else {
                    logger.warning("Auth error");
                    AgentMonitorMessageQueue.getInstance().pushAgentMessage("Auth error");
                    AgentV3Report report = new AgentV3Report();
                    SnmpPDU reportPDU = report.sendWrongDigestsReport(this.receiveMsgID);
                    this.sendReportPDU(inPacket, msgID.toString(), reportPDU);
                    return;
                }
            }
        }
        if (msgAuthenticationParameters == null) {
            logger.warning("msgAuthenticationParameters Null");
        }
        if (msgPrivacyParameters == null) {
            logger.warning("msgPrivacyParameters Null");
        }
        SnmpSequence scopedPDUData = null;
        if (this.privFlag) {
            SnmpOctetString scopedPDUOctet = (SnmpOctetString)request.getSNMPObjectAt(3);
            try {
                SnmpPDU reportPDU;
                AgentV3Report report;
                SnmpSequence scopedPDUDataWork = null;
                scopedPDUDataWork = UsmSecuritySubsystem.getInstance().decrypt((byte[])scopedPDUOctet.getValue(), (byte[])msgPrivacyParameters.getValue(), this.usmUserEntry.getUsmUserPrivKey());
                if (scopedPDUDataWork == null) {
                    logger.warning("Abort decrypt scopedPDU");
                    report = new AgentV3Report();
                    reportPDU = report.sendDecryptionErrorReport(this.receiveMsgID);
                    this.sendReportPDU(inPacket, msgID.toString(), reportPDU);
                    return;
                }
                try {
                    scopedPDUData = (SnmpSequence)scopedPDUDataWork.getSNMPObjectAt(0);
                }
                catch (ClassCastException classCastException) {
                    logger.warning("Abort Snmp BER Coding by decrypt scopedPDU");
                    report = new AgentV3Report();
                    reportPDU = report.sendDecryptionErrorReport(this.receiveMsgID);
                    this.sendReportPDU(inPacket, msgID.toString(), reportPDU);
                    return;
                }
                logger.info("Decrypt scopedPDUData : " + this.hexBytetoString(scopedPDUData.getBEREncoding(), scopedPDUData.getBEREncoding().length));
            }
            catch (GeneralSecurityException e4) {
                logger.warning("Decrypt scopedPDUData : " + e4.getMessage());
                e4.printStackTrace();
                throw e4;
            }
        }
        scopedPDUData = (SnmpSequence)request.getSNMPObjectAt(3);
        logger.info("Plain scopedPDUData : " + this.hexBytetoString(scopedPDUData.getBEREncoding(), scopedPDUData.getBEREncoding().length));
        if (scopedPDUData == null) {
            logger.warning("Scoped PDU Data null");
            throw new SnmpBadValueException("Scoped PDU Data null");
        }
        contextEngineID = scopedPDUData.getSNMPObjectAt(0);
        logger.info("contextEngineID : " + contextEngineID);
        AgentMonitorMessageQueue.getInstance().pushAgentMessage("contextEngineID : " + contextEngineID);
        contextName = scopedPDUData.getSNMPObjectAt(1);
        logger.info("contextName : " + contextName);
        AgentMonitorMessageQueue.getInstance().pushAgentMessage("contextName : " + contextName);
        SnmpPDU pduData = (SnmpPDU)scopedPDUData.getSNMPObjectAt(2);
        logger.info("PDU-Type : " + this.setCommandLog(pduData.getPDUType()) + "(" + this.hexByte(pduData.getPDUType()) + ")");
        logger.info("PDU Data" + this.hexBytetoString(pduData.getBEREncoding(), pduData.getBEREncoding().length));
        AgentMonitorMessageQueue.getInstance().pushAgentMessage("PDU-Type : " + this.setCommandLog(pduData.getPDUType()) + "(" + this.hexByte(pduData.getPDUType()) + ")");
        Date date = Calendar.getInstance().getTime();
        AgentMonitorMessageQueue.getInstance().pushAgentMessage("PDU Receive date : " + dateformat.format(date) + " : Data length : " + pduData.getBEREncoding().length + "Byte");
        AgentMonitorMessageQueue.getInstance().pushAgentMessage(this.hexBytetoString(pduData.getBEREncoding(), pduData.getBEREncoding().length));
        this.parsePDUData(inPacket, pduData);
    }

    private void parsePDUData(DatagramPacket inPacket, SnmpPDU pduData) throws GeneralSecurityException, SnmpBadValueException, IOException {
        SnmpSequence varList = null;
        SnmpSequence responseSeq = null;
        logger.info("Receive Data Parse Start");
        logger.info("PDU-Type : " + this.hexByte(pduData.getPDUType()));
        if (pduData.getErrorStatus() != 0) {
            logger.warning("Error status " + pduData.getErrorStatus());
        }
        varList = pduData.getVarBindList();
        int requestID = pduData.getRequestID();
        if (msgAuthoritativeEngineID == null || ((byte[])msgAuthoritativeEngineID.getValue()).length <= 0) {
            logger.info("Discovery snmpEngienID");
            this.snmpV3AgentConfigInfo.setDiscoveryLearned(false);
            AgentV3DiscoverySequence discovery = new AgentV3DiscoverySequence();
            try {
                responseSeq = discovery.createDiscoverySnmpEngineIDMessage(requestID, msgID.getValue().toString());
            }
            catch (SnmpBadValueException e) {
                logger.info("Discovery snmpEngienID : " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            byte[] messageEncoding = responseSeq.getBEREncoding();
            DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
            try {
                this.resSendDatagramSocket.send(outPacket);
            }
            catch (IOException e1) {
                logger.info("Abort discovery snmpEngienID send report : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
            return;
        }
        if (this.msgAuthoritativeBoots.toString().equals("0") && this.msgAuthoritativeEngineTime.toString().equals("0") && varList.size() < 1) {
            logger.info("Discovery snmpBoots and snmpEngineTime");
            AgentV3DiscoverySequence discovery = new AgentV3DiscoverySequence();
            try {
                responseSeq = discovery.createDiscoveryBootsAndTimeMessage(requestID, msgAuthoritativeEngineID.toString().substring(2), msgID.getValue().toString());
            }
            catch (GeneralSecurityException e1) {
                logger.warning("Discovery snmpBoots and snmpEngineTime : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
            catch (SnmpBadValueException e1) {
                logger.warning("Discovery snmpBoots and snmpEngineTime : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
            byte[] messageEncoding = responseSeq.getBEREncoding();
            DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
            try {
                this.resSendDatagramSocket.send(outPacket);
                logger.info("Discover SnmpV3 Boots&Time Report Send :" + this.hexBytetoString(messageEncoding, outPacket.getLength()));
            }
            catch (IOException e1) {
                logger.warning("Error send report for discovery snmpBoots and snmpEngineTime : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
            return;
        }
        try {
            if (this.checkUsm()) {
                logger.warning("USM Check error");
                return;
            }
        }
        catch (SnmpBadValueException e) {
            logger.warning("Error check USM : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        responseSeq = this.parseMessage(requestID, msgID.getValue().toString(), pduData);
        byte[] messageEncoding = responseSeq.getBEREncoding();
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
        try {
            this.resSendDatagramSocket.send(outPacket);
            logger.info("Usual Response Data Send :" + this.hexBytetoString(messageEncoding, outPacket.getLength()));
        }
        catch (IOException e1) {
            logger.warning("Error send report response : " + e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
        this.snmpV3AgentConfigInfo.setDiscoveryLearned(true);
    }

    public SnmpSequence parseMessage(int requestID, String msgIDString, SnmpPDU pduData) throws GeneralSecurityException, SnmpBadValueException {
        SnmpSequence sendSNMPSequence;
        block22: {
            SnmpSequence varList = new SnmpSequence();
            varList = pduData.getVarBindList();
            int snmpVersion = 3;
            int securityModel = 3;
            int msgID = Integer.parseInt(msgIDString);
            SnmpV3AgentConfigInfo snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
            String snmpV3AgentSnmpEngineID = snmpV3AgentConfigInfo.getSnmpEngineID();
            SnmpEngineID snmpEngineID = new SnmpEngineID(snmpV3AgentSnmpEngineID);
            int snmpEngineBoots = 0;
            String contextName = snmpV3AgentConfigInfo.getContextName();
            sendSNMPSequence = new SnmpSequence();
            SnmpSequence msgSecurityParameters = null;
            try {
                sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
                SnmpSequence msgGlobalData = new SnmpSequence();
                msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
                msgGlobalData.addSNMPObject(new SnmpInteger(8192L));
                byte msgFlag = 0;
                if (this.authFlag) {
                    msgFlag = (byte)(msgFlag | 1);
                }
                if (this.privFlag) {
                    msgFlag = (byte)(msgFlag | 2);
                }
                msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
                msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
                sendSNMPSequence.addSNMPObject(msgGlobalData);
                logger.info("Discovery Learned : " + snmpV3AgentConfigInfo.isDiscoveryLearned());
                logger.info("authFlag : " + this.authFlag);
                logger.info("privFlag : " + this.privFlag);
                logger.info("msgFlag : " + msgFlag);
                msgSecurityParameters = new SnmpSequence();
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
                int snmpEngineTime = (int)((System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 1000L);
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
                logger.info("userName : " + this.userName);
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(this.userName));
                if (this.authFlag) {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[12]));
                } else {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                byte[] iv = null;
                if (this.privFlag) {
                    iv = UsmSecuritySubsystem.getInstance().getIV(snmpEngineBoots);
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.getInstance().getSalt(this.usmUserEntry.getUsmUserPrivKey(), iv)));
                } else {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
                SnmpSequence msgData = new SnmpSequence();
                msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgData.addSNMPObject(new SnmpOctetString(contextName));
                SnmpPDU sendPDU = null;
                byte command = 0;
                command = pduData.getPDUType();
                switch (command) {
                    case -96: {
                        sendPDU = this.createResponsePDU(requestID, varList);
                        break;
                    }
                    case -95: {
                        sendPDU = this.createResponsePDU(requestID, varList);
                        break;
                    }
                    case -93: {
                        sendPDU = this.setRequest(requestID, varList);
                        break;
                    }
                    default: {
                        logger.warning("Not defined : " + command);
                    }
                }
                msgData.addSNMPObject(sendPDU);
                logger.info("authFlag : " + this.authFlag);
                logger.info("privFlag : " + this.privFlag);
                logger.info("isDiscoveryLearned : " + snmpV3AgentConfigInfo.isDiscoveryLearned());
                if (this.privFlag) {
                    try {
                        if (SnmpErrorTest.getInstance().getAgentErrorControlCode() != null && SnmpErrorTest.getInstance().getAgentErrorControlCode().equals("Descryption error")) {
                            logger.info("Error test Decryption error");
                            sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgData.getBEREncoding()));
                        }
                        sendSNMPSequence.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.encrypt(msgData, iv, this.usmUserEntry.getUsmUserPrivKey())));
                    }
                    catch (GeneralSecurityException e2) {
                        logger.warning("Create encrypt Scoped PDU Data : " + e2.getMessage());
                        e2.printStackTrace();
                        throw e2;
                    }
                } else {
                    logger.info("Create plain Scoped PDU Data");
                    sendSNMPSequence.addSNMPObject(msgData);
                }
                if (!this.authFlag) break block22;
                logger.info("Create authentication SecurityParams");
                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;
                    if (SnmpErrorTest.getInstance().getAgentErrorControlCode() != null && SnmpErrorTest.getInstance().getAgentErrorControlCode().equals("Wrong digest")) {
                        logger.info("Error test Wrong digest");
                        msgAuthenticationParametersOctet = new SnmpOctetString();
                    } else {
                        msgAuthenticationParametersOctet = UsmSecuritySubsystem.getInstance().setAuth(sendSNMPSequence, msgSecurityParameters, this.usmUserEntry.getUsmUserAuthKey());
                    }
                    msgSecurityParameters.addSNMPObject(msgAuthenticationParametersOctet, 4);
                }
                catch (GeneralSecurityException e2) {
                    logger.warning("Error create authentication SecurityParams : " + e2.getMessage());
                    e2.printStackTrace();
                }
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()), 2);
            }
            catch (SnmpBadValueException e1) {
                logger.warning("Error parse message : " + e1.getMessage());
                e1.printStackTrace();
                throw e1;
            }
        }
        return sendSNMPSequence;
    }

    private boolean checkUsm() throws SnmpBadValueException, IOException {
        SnmpPDU reportPduData = null;
        int snmpEngineTime = (int)((System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 1000L);
        if (SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Wrong digest")) {
            logger.warning("Wrong digest : 1.3.6.1.6.3.15.1.1.5.0");
            AgentV3Report report = new AgentV3Report();
            reportPduData = report.sendWrongDigestsReport(this.receiveMsgID);
            this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
        } else if (SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Descryption error")) {
            logger.warning("Descryption error : 1.3.6.1.6.3.15.1.1.6.0");
            AgentV3Report report = new AgentV3Report();
            reportPduData = report.sendDecryptionErrorReport(this.receiveMsgID);
            this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
        } else if (!this.receiveCheckEngineID.equals(this.snmpEngineID) || SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Unknown engine ID")) {
            logger.warning("Unknown engine ID : 1.3.6.1.6.3.15.1.1.4.0");
            logger.warning("Receive EngineID : " + this.receiveCheckEngineID);
            logger.warning("Agent EngineID : " + this.snmpEngineID);
            AgentV3Report report = new AgentV3Report();
            reportPduData = report.sendUnknownEngineIDReport(this.receiveMsgID);
            this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
        } else {
            this.usmUserEntry = UsmUserAgentManager.getInstance().getUsmUserEntry(new SnmpEngineID(this.snmpEngineID), this.receiveCheckUserName);
            if (this.usmUserEntry == null || SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Unknown user name")) {
                logger.warning("UnknownUserNames");
                logger.warning("receiveCheckUserName" + this.receiveCheckUserName);
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendUnknownUserNamesReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            } else if (!this.authFlag && this.usmUserEntry.getUsmUserAuthProtocol() != UsmUserEntry.USM_NO_AUTH_PROTOCOL || SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Unsupported security level")) {
                logger.warning("UnsupportedSecLevels");
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendUnsupportedSecurityLevelReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            } else if (this.authFlag && this.usmUserEntry.getUsmUserAuthProtocol() == UsmUserEntry.USM_NO_AUTH_PROTOCOL) {
                logger.warning("UnsupportedSecLevels");
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendUnsupportedSecurityLevelReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            } else if (!this.privFlag && this.usmUserEntry.getUsmUserPrivProtocol() != UsmUserEntry.USM_NO_PRIV_PROTOCOL) {
                logger.warning("UnsupportedSecLevels");
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendUnsupportedSecurityLevelReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            } else if (this.privFlag && this.usmUserEntry.getUsmUserPrivProtocol() == UsmUserEntry.USM_NO_PRIV_PROTOCOL) {
                logger.warning("UnsupportedSecLevels");
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendUnsupportedSecurityLevelReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            } else if (this.receiveCheckBoots != Long.parseLong(this.snmpV3AgentConfigInfo.getSnmpEngineBoots()) || this.receiveCheckEngineTime < (long)(snmpEngineTime - 150) || this.receiveCheckEngineTime > (long)(snmpEngineTime + 150) || SnmpErrorTest.getInstance().getAgentErrorReportCode().equals("Not in time packet")) {
                logger.warning("Receive EngineBoots : " + this.receiveCheckBoots);
                logger.warning("Agent EngineBoots : " + this.snmpV3AgentConfigInfo.getSnmpEngineBoots());
                logger.warning("Receive EngineTime : " + this.msgAuthoritativeEngineTime.toString());
                logger.warning("Agent EngineTime : " + snmpEngineTime);
                AgentV3Report report = new AgentV3Report();
                reportPduData = report.sendNotInTimeWindowsReport(this.receiveMsgID);
                this.sendReportPDU(this.inPacket, msgID.toString(), reportPduData);
            }
        }
        return reportPduData != null;
    }

    private SnmpPDU setRequest(int requestID, SnmpSequence varList) throws SnmpBadValueException {
        SnmpPDU pdu;
        block9: {
            int errorStatus = 0;
            int errorIndex = 0;
            SnmpVarBindList varbindList = new SnmpVarBindList();
            pdu = null;
            try {
                SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(0);
                SnmpObjectIdentifier setReqSnmpOID = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
                AbstractSnmpObject setReqObject = newPair.getSNMPObjectAt(1);
                varbindList.addSNMPObject(newPair);
                errorStatus = 0;
                String setRequestOID = setReqSnmpOID.toString();
                AbstractSnmpObject responseSnmpValue = null;
                boolean found = false;
                if (agentOidHashMap.containsKey(setRequestOID)) {
                    MibInfo miboid = (MibInfo)agentOidHashMap.get(setRequestOID);
                    logger.info("retrievedID : " + setRequestOID);
                    logger.info("object : " + setReqObject);
                    logger.info("getInstanceNo : " + miboid.getInstanceNo());
                    logger.info("getAccess : " + miboid.getAccess());
                    AgentMonitorMessageQueue.getInstance().pushAgentMessage("SetRequest OID = " + setRequestOID);
                    AgentMonitorMessageQueue.getInstance().pushAgentMessage("SetRequest Object = " + setReqObject);
                    miboid.setAgentMibValue(setReqObject);
                    miboid.setValue(setReqObject.toString());
                    AgentMibTree.getInstance().getOidHashMap().put(setRequestOID, miboid);
                    miboid = AgentInstanceDataMap.getInstance().getAgentInstanceDataInfo(setRequestOID);
                    miboid.setAgentMibValue(setReqObject);
                    miboid.setValue(setReqObject.toString());
                    AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(setRequestOID, miboid);
                    AgentInstanceDataRefreshQueue.getInstance().pushQueue(miboid);
                    if (miboid.isAgentInstance()) {
                        logger.info("instance : " + miboid.getAccess());
                        logger.info("Descrip : " + miboid.getDescrip() + " access : " + miboid.getAccess());
                    }
                    if (miboid != null) {
                        responseSnmpValue = setReqObject;
                        found = true;
                    } else {
                        errorStatus = 2;
                        responseSnmpValue = new SnmpNull();
                        found = true;
                    }
                } else {
                    logger.warning("Not defined SetRequest OID : " + setRequestOID);
                    errorStatus = 2;
                    responseSnmpValue = new SnmpNull();
                    found = true;
                }
                if (!found) break block9;
                logger.info("message snmp oid : " + setRequestOID);
                try {
                    SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(setRequestOID);
                    SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, responseSnmpValue);
                    SnmpSequence varList2 = new SnmpSequence();
                    varList2.addSNMPObject(nextPair);
                    pdu = new SnmpPDU(-94, requestID, errorStatus, errorIndex, varList2);
                }
                catch (SnmpBadValueException e) {
                    logger.warning("Abort create response PDU for setRequest : " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
            }
            catch (SnmpBadValueException e) {
                logger.warning("Abort parse SetRequest data : " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
        return pdu;
    }

    public SnmpPDU createResponsePDU(int requestID, SnmpSequence varList) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;
        SnmpPDU pdu = null;
        SnmpSequence responseVarList = new SnmpSequence();
        int varListCount = varList.getSequenceContentsList().size();
        int contentCount = 0;
        while (contentCount < varListCount) {
            boolean isFoundOID = false;
            String requestOID = "";
            SnmpSequence newPair = (SnmpSequence)varList.getSNMPObjectAt(contentCount);
            SnmpObjectIdentifier newObjectIdentifier = (SnmpObjectIdentifier)newPair.getSNMPObjectAt(0);
            requestOID = newObjectIdentifier.toString();
            logger.info("Request OID = " + requestOID);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage("Request OID = " + requestOID);
            AbstractSnmpObject snmpValue = null;
            if (requestOID.equals("1.0")) {
                requestOID = "1.3";
            }
            String nextMibOid = null;
            if (agentOidHashMap.containsKey(requestOID)) {
                MibInfo miboid = (MibInfo)agentOidHashMap.get(requestOID);
                MibInfo nextmiboid = null;
                while ((miboid = (MibInfo)agentOidHashMap.get(requestOID)) != null && (nextmiboid = (MibInfo)agentOidHashMap.get(miboid.getNextMibOid())) != null && !nextmiboid.isAgentInstance()) {
                    requestOID = miboid.getNextMibOid();
                }
                if (miboid != null && nextmiboid != null) {
                    nextMibOid = miboid.getNextMibOid();
                    snmpValue = ((MibInfo)agentOidHashMap.get(nextMibOid)).getAgentMibValue();
                    requestOID = ((MibInfo)agentOidHashMap.get(requestOID)).getNextMibOid();
                    isFoundOID = true;
                } else {
                    errorStatus = 2;
                    snmpValue = new SnmpNull();
                    isFoundOID = true;
                }
            } else {
                errorStatus = 2;
                logger.warning("unmuch OID : " + requestOID);
                if (nextMibOid != null) {
                    requestOID = nextMibOid;
                }
                snmpValue = new SnmpNull();
                isFoundOID = true;
            }
            if (isFoundOID) {
                logger.info("message snmp oid : " + requestOID);
                SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier(requestOID);
                SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, snmpValue);
                responseVarList.addSNMPObject(nextPair);
            }
            ++contentCount;
        }
        try {
            pdu = new SnmpPDU(-94, requestID, errorStatus, errorIndex, responseVarList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create message of response PDU : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return pdu;
    }

    public void sendTrap(String hostAddress, String community, SnmpSequence pdu) throws GeneralSecurityException, UnknownHostException, SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        int msgID = 0;
        InetAddress targetAddress = null;
        try {
            targetAddress = InetAddress.getByName(hostAddress);
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        SnmpSequence message = this.createTrap3Message(msgID, (SnmpTrap2PDU)pdu);
        byte[] messageEncoding = message.getBEREncoding();
        logger.info("Trap send Version3 : " + this.hexBytetoString(messageEncoding, messageEncoding.length));
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, targetAddress, trapPort);
        this.trapDatagramSocket.send(outPacket);
    }

    private void sendReportPDU(DatagramPacket inPacket, String msgIDString, SnmpPDU reportPDUData) throws IOException {
        SnmpSequence responseSeq = this.createReportMessage(msgIDString, reportPDUData);
        byte[] messageEncoding = responseSeq.getBEREncoding();
        DatagramPacket outPacket = new DatagramPacket(messageEncoding, messageEncoding.length, inPacket.getAddress(), inPacket.getPort());
        try {
            this.resSendDatagramSocket.send(outPacket);
        }
        catch (IOException e1) {
            logger.warning("Error send report message : " + e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
    }

    public SnmpSequence createReportMessage(String msgIDString, SnmpPDU reportPDUData) {
        int snmpVersion = 3;
        int securityModel = 3;
        int msgID = Integer.parseInt(msgIDString);
        SnmpV3AgentConfigInfo snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        String snmpV3AgentSnmpEngineID = snmpV3AgentConfigInfo.getSnmpEngineID();
        SnmpEngineID snmpEngineID = new SnmpEngineID(snmpV3AgentSnmpEngineID);
        int snmpEngineBoots = 0;
        String contextName = snmpV3AgentConfigInfo.getContextName();
        SnmpSequence sendSNMPSequence = new SnmpSequence();
        SnmpSequence msgSecurityParameters = null;
        sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
        SnmpSequence msgGlobalData = new SnmpSequence();
        msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
        msgGlobalData.addSNMPObject(new SnmpInteger(8192L));
        byte msgFlag = 4;
        if (this.privFlag) {
            msgFlag = (byte)(msgFlag | 2);
        }
        msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
        msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
        sendSNMPSequence.addSNMPObject(msgGlobalData);
        msgSecurityParameters = new SnmpSequence();
        msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
        msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
        int snmpEngineTime = (int)((System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 1000L);
        msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
        msgSecurityParameters.addSNMPObject(new SnmpOctetString(this.userName));
        msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
        byte[] iv = null;
        logger.info("usmUserEntry snmpEngineID : " + snmpEngineID);
        logger.info("usmUserEntry userName : " + this.userName);
        this.usmUserEntry = UsmUserAgentManager.getInstance().getUsmUserEntry(snmpEngineID, this.userName);
        if (this.privFlag) {
            iv = UsmSecuritySubsystem.getInstance().getIV(snmpEngineBoots);
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.getInstance().getSalt(this.usmUserEntry.getUsmUserPrivKey(), iv)));
        } else {
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
        }
        sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
        SnmpSequence msgData = new SnmpSequence();
        msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
        msgData.addSNMPObject(new SnmpOctetString(contextName));
        msgData.addSNMPObject(reportPDUData);
        sendSNMPSequence.addSNMPObject(msgData);
        return sendSNMPSequence;
    }

    public SnmpSequence createTrap3Message(int trapMsgID, SnmpTrap2PDU trapPdu) throws GeneralSecurityException, SnmpV3ConfigurationException {
        int snmpVersion = 3;
        int securityModel = 3;
        int msgID = trapMsgID;
        int snmpEngineBoots = 0;
        long agentStartTime = 0L;
        SnmpV3AgentConfigInfo snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        String snmpV3AgentSnmpEngineID = snmpV3AgentConfigInfo.getSnmpEngineID();
        snmpEngineBoots = Integer.parseInt(snmpV3AgentConfigInfo.getSnmpEngineBoots());
        SnmpEngineID snmpEngineID = new SnmpEngineID(snmpV3AgentSnmpEngineID);
        String userName = snmpV3AgentConfigInfo.getUserName();
        this.authPriv = snmpV3AgentConfigInfo.getAuthPriv();
        UsmUserEntry usmUserEntry = null;
        usmUserEntry = UsmUserAgentManager.getInstance().getUsmUserEntry(snmpEngineID, userName);
        if (usmUserEntry == null) {
            logger.info("Not found USM user entry");
            logger.info("snmpEngineID : " + snmpEngineID);
            logger.info("userName : " + userName);
            throw new SnmpV3ConfigurationException("Not found USM user entry snmpEngineID : " + snmpEngineID + " userName : " + userName);
        }
        if (this.authPriv.equals("AUTH")) {
            this.authFlag = true;
            this.privFlag = false;
        } else if (this.authPriv.equals("PRIV")) {
            this.authFlag = true;
            this.privFlag = true;
        } else if (this.authPriv.equals("NOAUTH")) {
            this.authFlag = false;
            this.privFlag = false;
        }
        String contextName = snmpV3AgentConfigInfo.getContextName();
        SnmpSequence sendSNMPSequence = new SnmpSequence();
        SnmpSequence msgSecurityParameters = null;
        sendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
        SnmpSequence msgGlobalData = new SnmpSequence();
        msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
        msgGlobalData.addSNMPObject(new SnmpInteger(8192L));
        byte msgFlag = 4;
        if (this.authFlag) {
            msgFlag = (byte)(msgFlag | 1);
        }
        if (this.privFlag) {
            msgFlag = (byte)(msgFlag | 2);
        }
        msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
        msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
        sendSNMPSequence.addSNMPObject(msgGlobalData);
        msgSecurityParameters = new SnmpSequence();
        msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
        msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
        int snmpEngineTime = (int)((System.currentTimeMillis() - agentStartTime) / 1000L);
        msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
        msgSecurityParameters.addSNMPObject(new SnmpOctetString(userName));
        if (this.authFlag) {
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[12]));
        } else {
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
        }
        byte[] iv = null;
        if (this.privFlag) {
            iv = UsmSecuritySubsystem.getInstance().getIV(snmpEngineBoots);
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.getInstance().getSalt(usmUserEntry.getUsmUserPrivKey(), iv)));
        } else {
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
        }
        sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
        SnmpSequence msgData = new SnmpSequence();
        msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
        msgData.addSNMPObject(new SnmpOctetString(contextName));
        int trapRequestID = 0;
        int errorStatus = 0;
        int errorIndex = 0;
        trapPdu.setPDU(trapRequestID, errorStatus, errorIndex);
        msgData.addSNMPObject(trapPdu);
        if (this.privFlag) {
            try {
                sendSNMPSequence.addSNMPObject(new SnmpOctetString(UsmSecuritySubsystem.encrypt(msgData, iv, usmUserEntry.getUsmUserPrivKey())));
            }
            catch (GeneralSecurityException e2) {
                logger.warning("Eorror encrypt data for create trap message : " + e2.getMessage());
                e2.printStackTrace();
                throw e2;
            }
        } else {
            sendSNMPSequence.addSNMPObject(msgData);
        }
        if (this.authFlag) {
            try {
                SnmpOctetString msgAuthenticationParametersOctet = null;
                msgAuthenticationParametersOctet = UsmSecuritySubsystem.getInstance().setAuth(sendSNMPSequence, msgSecurityParameters, usmUserEntry.getUsmUserAuthKey());
                msgSecurityParameters.addSNMPObject(msgAuthenticationParametersOctet, 4);
            }
            catch (GeneralSecurityException e2) {
                logger.warning("Error create msgAuthenticationParameters MAC for create trap message : " + e2.getMessage());
                e2.printStackTrace();
                throw e2;
            }
            sendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()), 2);
        }
        return sendSNMPSequence;
    }

    private String setCommandLog(byte code) {
        String snmpCode = "";
        switch (code) {
            case -96: {
                snmpCode = "GetRequest";
                break;
            }
            case -95: {
                snmpCode = "GetNextRequest";
                break;
            }
            case -93: {
                snmpCode = "SetRequest";
                break;
            }
            default: {
                snmpCode = "Unknown";
            }
        }
        return snmpCode;
    }
}

