/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import java.util.ArrayList;
import java.util.HashMap;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpmanager.OidTreeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class OidTreeView
extends ViewPart {
    public static final int EXPANDED_LEVEL = 9;
    public static final String INIT_SELECT_OID = "1.3.6.1.2.1.1.1";

    public void createPartControl(Composite parent) {
        ManagerMibTree oidTreeInstance = ManagerMibTree.getInstance();
        ArrayList oidList = oidTreeInstance.getOidList();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Tree tree = new Tree(parent, 2048);
        TreeItem roottWork = new TreeItem(tree, 0);
        MibInfo rootOidInfo = (MibInfo)oidList.get(0);
        String rootOid = ((MibInfo)oidList.get(0)).getOid();
        String rootDescrip = ((MibInfo)oidList.get(0)).getDescrip();
        roottWork.setText(String.valueOf(rootDescrip) + "(" + rootOid + ")");
        roottWork.setData((Object)rootOidInfo);
        HashMap<String, TreeItem> oidTreeMap = new HashMap<String, TreeItem>();
        oidTreeMap.put(rootOid, roottWork);
        int i = 0;
        while (i < oidList.size()) {
            MibInfo oidInfo = (MibInfo)oidList.get(i);
            String oid = ((MibInfo)oidList.get(i)).getOid();
            String oidDiscrip = ((MibInfo)oidList.get(i)).getDescrip();
            String parentOid = ((MibInfo)oidList.get(i)).getParentOid();
            if (oidTreeMap.containsKey(parentOid)) {
                TreeItem parentTreeItem = (TreeItem)oidTreeMap.get(parentOid);
                TreeItem treeItem = new TreeItem(parentTreeItem, 0);
                treeItem.setText(String.valueOf(oidDiscrip) + "(" + oid + ")");
                treeItem.setData((Object)oidInfo);
                oidTreeMap.put(oid, treeItem);
            }
            ++i;
        }
        TreeItem[] treeItems = new TreeItem[1];
        int i2 = 0;
        while (i2 < 9) {
            String workOid = ((MibInfo)oidList.get(i2)).getOid();
            TreeItem expandTreeItem = (TreeItem)oidTreeMap.get(workOid);
            expandTreeItem.setExpanded(true);
            if (i2 == 0) {
                treeItems[0] = expandTreeItem;
            }
            ++i2;
        }
        tree.setLayoutData((Object)gridData);
        tree.setSelection(treeItems);
        tree.addSelectionListener((SelectionListener)OidTreeListener.getInstance());
    }

    public void setFocus() {
    }
}

