/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.socketclient.EngineInfo;
import netjfwatcher.socketclient.IEngineNode;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EngineListListener
implements ISelectionChangedListener {
    private TreeViewer engineListTreeViewer;

    public EngineListListener(TreeViewer engineListTreeViewer) {
        this.engineListTreeViewer = engineListTreeViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        EngineInfo engineInfo;
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        if (ss.getFirstElement() instanceof IEngineNode) {
            IEngineNode entry = (IEngineNode)ss.getFirstElement();
            engineInfo = entry.getEngineInfo();
        } else {
            engineInfo = null;
        }
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (engineInfo != null) {
                    ClientEngineInfo.getClientEngineInfoInstance().setEngineAddress(engineInfo.getEngineAddress());
                    EngineListListener.this.engineListTreeViewer.refresh();
                }
            }
        });
    }
}

