/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.macaddress.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionInterfaceMib;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceMib;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.macaddress.preference.MacAddressConfig;
import netjfwatcher.macaddress.preference.MacAddressInfo;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class NodeMacAddressEditorView
extends AbstractEditorNodeView {
    private static Logger logger;
    private static final int OUI_LENGTH = 6;
    private static final float COLUMN_NO_RATIO = 0.04f;
    private static final float COLUMN_IP_RATIO = 0.1f;
    private static final float COLUMN_NODENAME_RATIO = 0.1f;
    private static final float COLUMN_IFINDEX_RATIO = 0.04f;
    private static final float COLUMN_IFDESC_RATIO = 0.1f;
    private static final float COLUMN_IFTYPE_RATIO = 0.1f;
    private static final float COLUMN_IFMTU_RATIO = 0.1f;
    private static final float COLUMN_IFSPEED_RATIO = 0.1f;
    private static final float COLUMN_IFPHYSADDRESS_RATIO = 0.3f;
    private static final float COLUMN_IFSTATUS_RATIO = 0.1f;
    private static final int NO_POS = 0;
    private static final int IP_ADDRESS_POS = 1;
    private static final int NODE_NAME_POS = 2;
    private static final int IFINDEX_POS = 3;
    private static final int IFDESC_POS = 4;
    private static final int IFTYPE_POS = 5;
    private static final int IFMTU_POS = 6;
    private static final int IFSPEED_POS = 7;
    private static final int IFPHYSADDRESS_POS = 8;
    private static final int IFSTATUS_POS = 9;
    private static final int COLUMN_NO = 10;
    private Button refreshButton;
    private Button socketClientButton;
    private TableViewer viewer;
    private Color textBackColor;
    private long ifCount = 0L;

    public NodeMacAddressEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        this.refreshButton = new Button(composite, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLayoutData((Object)new GridData());
        this.socketClientButton = new Button(composite, 0);
        this.socketClientButton.setText("Socket Client");
        this.socketClientButton.setLayoutData((Object)new GridData());
        SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
        this.table = statisticsTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.setNodeInterfaceTable(false, false);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NodeMacAddressEditorView.this.refreshButton.setEnabled(false);
                NodeMacAddressEditorView.this.setNodeInterfaceTable(false, true);
                NodeMacAddressEditorView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.socketClientButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NodeMacAddressEditorView.this.socketClientButton.setEnabled(false);
                NodeMacAddressEditorView.this.setNodeInterfaceTable(true, true);
                NodeMacAddressEditorView.this.socketClientButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setNodeInterfaceTable(boolean isSocket, boolean isShow) {
        this.table.removeAll();
        this.viewer.refresh();
        this.ifCount = 0L;
        ArrayList nodeList = this.getNodeList(isSocket, isShow);
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.size()) {
            NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
            ArrayList interfaceMibList = this.getInterfaceMib(nodeInfo, isShow, isSocket);
            this.setInterfaceMibTable(nodeInfo, interfaceMibList);
            ++i;
        }
    }

    private ArrayList getNodeList(boolean isSocket, boolean isShowErrorDialog) {
        ArrayList nodeList = null;
        if (!isSocket) {
            DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
            try {
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return null;
            }
            catch (Exception e1) {
                logger.warning(e1.getMessage());
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)e1.getMessage());
                shell.dispose();
                return null;
            }
        }
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        try {
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            nodeList = connectNodeInfo.getNodeInformationList(null, null);
        }
        catch (EngineConnectException e1) {
            if (isShowErrorDialog) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e1.getMessage()) + " Engine = " + engineAddress));
                logger.warning("Node List import error" + e1.getMessage());
                shell.dispose();
            }
            return null;
        }
        catch (IOException e1) {
            if (isShowErrorDialog) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e1.getMessage()) + " Engine = " + engineAddress));
                logger.warning("Node List import error" + e1.getMessage());
                shell.dispose();
            }
            return null;
        }
        return nodeList;
    }

    private void setInterfaceMibTable(NodeInformation nodeInfo, ArrayList interfaceMibList) {
        if (interfaceMibList == null) {
            return;
        }
        InterfaceMib nodeInterfaceMib = null;
        int i = 0;
        while (i < interfaceMibList.size()) {
            ++this.ifCount;
            String[] interfaceTableCellArray = new String[10];
            nodeInterfaceMib = (InterfaceMib)interfaceMibList.get(i);
            interfaceTableCellArray[0] = Long.toString(this.ifCount);
            interfaceTableCellArray[1] = nodeInfo.getIpaddress();
            interfaceTableCellArray[2] = nodeInfo.getNodename();
            interfaceTableCellArray[3] = nodeInterfaceMib.getIfIndex();
            interfaceTableCellArray[4] = nodeInterfaceMib.getIfDesc();
            interfaceTableCellArray[5] = nodeInterfaceMib.getIfType();
            interfaceTableCellArray[6] = nodeInterfaceMib.getIfMtu();
            interfaceTableCellArray[7] = nodeInterfaceMib.getIfSpeed();
            String vedorName = this.searchVedorID(nodeInterfaceMib.getIfPhysAddress());
            interfaceTableCellArray[8] = vedorName.equals("") ? nodeInterfaceMib.getIfPhysAddress() : String.valueOf(nodeInterfaceMib.getIfPhysAddress()) + "  ( " + vedorName + " )";
            interfaceTableCellArray[9] = nodeInterfaceMib.getIfStatus();
            TableItem item = new TableItem(this.table, 0);
            item.setText(interfaceTableCellArray);
            item.setData((Object)interfaceTableCellArray);
            if (nodeInterfaceMib.getIfStatus().equals("Up")) {
                item.setForeground(Display.getCurrent().getSystemColor(9));
            }
            ++i;
        }
    }

    private String searchVedorID(String ifPhysAddress) {
        String vedorID = "";
        int head = "0X".length();
        if (ifPhysAddress == null || ifPhysAddress.equals("") || ifPhysAddress.length() < 8) {
            return vedorID;
        }
        String work = ifPhysAddress.substring(head, head + 6);
        String searchVendorID = work.toUpperCase();
        Map macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse().getMacInfoHashMap();
        if (macInfoHashMap.containsKey(searchVendorID)) {
            MacAddressInfo macInfo = (MacAddressInfo)macInfoHashMap.get(searchVendorID);
            vedorID = macInfo.getVendorInfo();
        }
        return vedorID;
    }

    private ArrayList getInterfaceMib(NodeInformation refreshNodeInfo, boolean isShowErrorDialog, boolean isSocket) {
        ArrayList interfaceMibList;
        block10: {
            interfaceMibList = null;
            if (!isSocket) {
                DBTableInterfaceMIB interfaceMibDBtable = DBTableInterfaceMIB.getInstance();
                try {
                    interfaceMibList = interfaceMibDBtable.findSNMPInterfaces(refreshNodeInfo.getIpaddress(), true);
                }
                catch (DatabaseConnectionException e2) {
                    logger.warning(e2.getMessage());
                    if (isShowErrorDialog) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                        shell.dispose();
                    }
                    break block10;
                }
                catch (SQLException e2) {
                    logger.warning(e2.getMessage());
                    if (isShowErrorDialog) {
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e2.getMessage());
                        shell.dispose();
                    }
                    break block10;
                }
            }
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionInterfaceMib connectInterfaceMib = new ConnectionInterfaceMib(engineAddress);
            try {
                interfaceMibList = connectInterfaceMib.getInterfaceMib(refreshNodeInfo.getIpaddress());
            }
            catch (EngineConnectException e) {
                logger.warning("Node Interface MIB import error" + e.getMessage());
                if (isShowErrorDialog) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                    shell.dispose();
                }
            }
            catch (IOException e) {
                logger.warning("Node Interface MIB import error" + e.getMessage());
                if (!isShowErrorDialog) break block10;
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Engine connect error", (String)("Engine connect error " + e.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
            }
        }
        return interfaceMibList;
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.04f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.04f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol6Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol7Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol8Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.3f);
    }

    private int computeCol9Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.textBackColor != null) {
            this.textBackColor.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    private final class SnmpInterfaceMibTable
    extends AbstractTableView {
        private boolean isCol0Direction = true;
        private boolean isCol1Direction = true;
        private boolean isCol2Direction = true;
        private boolean isCol3Direction = true;
        private boolean isCol4Direction = true;
        private boolean isCol5Direction = true;
        private boolean isCol6Direction = true;
        private boolean isCol7Direction = true;
        private boolean isCol8Direction = true;
        private boolean isCol9Direction = true;
        private TableColumn col0;
        private TableColumn col1;
        private TableColumn col2;
        private TableColumn col3;
        private TableColumn col4;
        private TableColumn col5;
        private TableColumn col6;
        private TableColumn col7;
        private TableColumn col8;
        private TableColumn col9;

        private SnmpInterfaceMibTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.col0 = new TableColumn(this.table, 0x1000000);
            this.col0.setText("No.");
            this.col0.setWidth(NodeMacAddressEditorView.this.computeCol0Width());
            this.col1 = new TableColumn(this.table, 0x1000000);
            this.col1.setText("IP Address");
            this.col1.setWidth(NodeMacAddressEditorView.this.computeCol1Width());
            this.col2 = new TableColumn(this.table, 0x1000000);
            this.col2.setText("Node Name");
            this.col2.setWidth(NodeMacAddressEditorView.this.computeCol2Width());
            this.col3 = new TableColumn(this.table, 0x1000000);
            this.col3.setText("ifIndex");
            this.col3.setWidth(NodeMacAddressEditorView.this.computeCol3Width());
            this.col4 = new TableColumn(this.table, 0x1000000);
            this.col4.setText("ifDesc");
            this.col4.setWidth(NodeMacAddressEditorView.this.computeCol4Width());
            this.col5 = new TableColumn(this.table, 0x1000000);
            this.col5.setText("ifType");
            this.col5.setWidth(NodeMacAddressEditorView.this.computeCol5Width());
            this.col6 = new TableColumn(this.table, 0x1000000);
            this.col6.setText("ifMtu");
            this.col6.setWidth(NodeMacAddressEditorView.this.computeCol6Width());
            this.col7 = new TableColumn(this.table, 0x1000000);
            this.col7.setText("ifSpeed");
            this.col7.setWidth(NodeMacAddressEditorView.this.computeCol7Width());
            this.col8 = new TableColumn(this.table, 0x1000000);
            this.col8.setText("ifPhysAddress");
            this.col8.setWidth(NodeMacAddressEditorView.this.computeCol8Width());
            this.col9 = new TableColumn(this.table, 0x1000000);
            this.col9.setText("ifStatus");
            this.col9.setWidth(NodeMacAddressEditorView.this.computeCol9Width());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    SnmpInterfaceMibTable.this.setResizedTableColumnWidth();
                }
            });
            this.col0.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol0Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 0, SnmpInterfaceMibTable.this.isCol0Direction);
                }
            });
            this.col1.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol1Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 1, SnmpInterfaceMibTable.this.isCol1Direction);
                }
            });
            this.col2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol2Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 2, SnmpInterfaceMibTable.this.isCol2Direction);
                }
            });
            this.col3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol3Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 3, SnmpInterfaceMibTable.this.isCol3Direction);
                }
            });
            this.col4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol4Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 4, SnmpInterfaceMibTable.this.isCol4Direction);
                }
            });
            this.col5.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol5Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 5, SnmpInterfaceMibTable.this.isCol5Direction);
                }
            });
            this.col6.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol6Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 6, SnmpInterfaceMibTable.this.isCol6Direction);
                }
            });
            this.col7.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol7Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 7, SnmpInterfaceMibTable.this.isCol7Direction);
                }
            });
            this.col8.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol8Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 8, SnmpInterfaceMibTable.this.isCol8Direction);
                }
            });
            this.col9.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol9Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 9, SnmpInterfaceMibTable.this.isCol9Direction);
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (NodeMacAddressEditorView.this.getEditorSite().getPage().isPartVisible(NodeMacAddressEditorView.this.getEditorSite().getPart()) && NodeMacAddressEditorView.this.getEditorSite().getShell() != null && NodeMacAddressEditorView.this.getEditorSite().getShell().getSize() != null) {
                this.col0.setWidth(NodeMacAddressEditorView.this.computeCol0Width());
                this.col1.setWidth(NodeMacAddressEditorView.this.computeCol1Width());
                this.col2.setWidth(NodeMacAddressEditorView.this.computeCol3Width());
                this.col3.setWidth(NodeMacAddressEditorView.this.computeCol3Width());
                this.col4.setWidth(NodeMacAddressEditorView.this.computeCol4Width());
                this.col5.setWidth(NodeMacAddressEditorView.this.computeCol5Width());
                this.col6.setWidth(NodeMacAddressEditorView.this.computeCol6Width());
                this.col7.setWidth(NodeMacAddressEditorView.this.computeCol7Width());
                this.col8.setWidth(NodeMacAddressEditorView.this.computeCol8Width());
                this.col9.setWidth(NodeMacAddressEditorView.this.computeCol9Width());
            }
        }

        protected TableItem setTableItem(Table table, TableItem item, String[] strs) {
            Color obj0 = item.getForeground();
            Color obj1 = item.getBackground();
            item.dispose();
            item = new TableItem(table, 0);
            item.setText(strs);
            item.setData((Object)strs);
            item.setForeground(obj0);
            item.setBackground(obj1);
            return item;
        }
    }
}

