/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.TimeZoneAdapter;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -744942128318337471L;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int SHORT_GENERIC = 2;
    private static final int LONG_GENERIC = 3;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    protected static final int MILLIS_PER_HOUR = 3600000;
    protected static final int MILLIS_PER_DAY = 86400000;
    static final int[][] GREGORIAN_MONTH_COUNT = new int[][]{{0, 0}, {31, 31}, {59, 60}, {90, 91}, {120, 121}, {151, 152}, {181, 182}, {212, 213}, {243, 244}, {273, 274}, {304, 305}, {334, 335}};
    private String ID;
    private static TimeZone defaultZone = null;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        int[] result = new int[2];
        this.getOffset(date, false, result);
        return result[0] + result[1];
    }

    public void getOffset(long date, boolean local, int[] offsets) {
        offsets[0] = this.getRawOffset();
        if (!local) {
            date += (long)offsets[0];
        }
        int pass = 0;
        while (true) {
            int[] fields = new int[4];
            long day = TimeZone.floorDivide(date, 86400000, fields);
            int millis = fields[0];
            TimeZone.computeGregorianFields(day, fields);
            offsets[1] = this.getOffset(1, fields[0], fields[1], fields[2], fields[3], millis) - offsets[0];
            if (pass != 0 || local || offsets[1] == 0 || TimeZone.floorDivide(date += (long)offsets[1], 86400000L) == day) break;
            ++pass;
        }
    }

    static long floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    static int floorDivide(long numerator, int denominator, int[] remainder) {
        if (numerator >= 0L) {
            remainder[0] = (int)(numerator % (long)denominator);
            return (int)(numerator / (long)denominator);
        }
        int quotient = (int)((numerator + 1L) / (long)denominator - 1L);
        remainder[0] = (int)(numerator - (long)(quotient * denominator));
        return quotient;
    }

    static void computeGregorianFields(long day, int[] fields) {
        int march1;
        int[] rem = new int[1];
        int n400 = TimeZone.floorDivide(day += 719162L, 146097, rem);
        int n100 = TimeZone.floorDivide(rem[0], 36524, rem);
        int n4 = TimeZone.floorDivide(rem[0], 1461, rem);
        int n1 = TimeZone.floorDivide(rem[0], 365, rem);
        int year = 400 * n400 + 100 * n100 + 4 * n4 + n1;
        int dayOfYear = rem[0];
        if (n100 == 4 || n1 == 4) {
            dayOfYear = 365;
        } else {
            ++year;
        }
        boolean isLeap = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
        int correction = 0;
        int n = march1 = isLeap ? 60 : 59;
        if (dayOfYear >= march1) {
            correction = isLeap ? 1 : 2;
        }
        int month = (12 * (dayOfYear + correction) + 6) / 367;
        int dayOfMonth = dayOfYear - GREGORIAN_MONTH_COUNT[month][isLeap ? 1 : 0] + 1;
        int dayOfWeek = (int)((day + 2L) % 7L);
        if (dayOfWeek < 1) {
            dayOfWeek += 7;
        }
        fields[0] = year;
        fields[1] = month;
        fields[2] = dayOfMonth;
        fields[3] = dayOfWeek;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
    }

    public final String getDisplayName() {
        return this._getDisplayName(false, 3, ULocale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this._getDisplayName(false, 3, ULocale.forLocale(locale));
    }

    public final String getDisplayName(ULocale locale) {
        return this._getDisplayName(false, 3, locale);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, ULocale.getDefault());
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        return this.getDisplayName(daylight, style, ULocale.forLocale(locale));
    }

    public String getDisplayName(boolean daylight, int style, ULocale locale) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Illegal style: " + style);
        }
        return this._getDisplayName(daylight, style, locale);
    }

    private String _getDisplayName(boolean daylight, int style, ULocale locale) {
        SimpleTimeZone tz;
        SimpleDateFormat format;
        SoftReference data = (SoftReference)cachedLocaleData.get(locale);
        if (data == null || (format = (SimpleDateFormat)data.get()) == null) {
            format = new SimpleDateFormat(null, locale);
            cachedLocaleData.put(locale, new SoftReference<SimpleDateFormat>(format));
        }
        if (daylight && this.useDaylightTime()) {
            int savings = this.getDSTSavings();
            tz = new SimpleTimeZone(this.getRawOffset(), this.getID(), 0, 1, 0, 0, 1, 1, 0, 0, savings);
        } else {
            tz = new SimpleTimeZone(this.getRawOffset(), this.getID());
        }
        String[] patterns = new String[]{"z", "zzzz", "v", "vvvv"};
        format.applyPattern(patterns[style]);
        format.setTimeZone(tz);
        return format.format(new Date(864000000L));
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        TimeZone result = ZoneMeta.getSystemTimeZone(ID);
        if (result == null) {
            result = ZoneMeta.getCustomTimeZone(ID);
        }
        if (result == null) {
            result = ZoneMeta.getGMT();
        }
        return result;
    }

    public static String[] getAvailableIDs(int rawOffset) {
        return ZoneMeta.getAvailableIDs(rawOffset);
    }

    public static String[] getAvailableIDs(String country) {
        return ZoneMeta.getAvailableIDs(country);
    }

    public static String[] getAvailableIDs() {
        return ZoneMeta.getAvailableIDs();
    }

    public static int countEquivalentIDs(String id) {
        return ZoneMeta.countEquivalentIDs(id);
    }

    public static String getEquivalentID(String id, int index) {
        return ZoneMeta.getEquivalentID(id, index);
    }

    public static synchronized TimeZone getDefault() {
        if (defaultZone == null) {
            java.util.TimeZone temp = java.util.TimeZone.getDefault();
            defaultZone = TimeZone.getTimeZone(temp.getID());
        }
        return (TimeZone)defaultZone.clone();
    }

    public static synchronized void setDefault(TimeZone tz) {
        defaultZone = tz;
        java.util.TimeZone jdkZone = null;
        if (tz != null) {
            jdkZone = TimeZoneAdapter.wrap(tz);
        }
        java.util.TimeZone.setDefault(jdkZone);
    }

    public boolean hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.ID = this.ID;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.ID.equals(((TimeZone)obj).ID);
    }

    public int hashCode() {
        return this.ID.hashCode();
    }
}

