/*
 * Created on 2004/04/27
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;


/**
 * f[^x[Xւ̃ANZX̂߂̃\bhNXłB
 * f[^x[XRlNVPoolCX^X擾AɁA
 * CX^XRlNV擾āAf[^x[Xɑ΂
 * \bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DatabaseAccess {
    /* f[^x[XRlNV擾gC */
    private static final int CONNECTION_TRY_COUNT = 30;

    /**
     * RlNVPoolp̃NXCX^X擾܂B
     *
     */
    protected DatabaseAccess() {
    }

    /**
     * SQL ̔s
     */

    /* public ResultSet executeSQL(String sql) throws SQLException {
            Connection connection = null;
            ResultSet resultset = null;
            try {
                    connection = getConnection();
                    Statement statement = connection.createStatement();
                    resultset = statement.executeQuery(sql);
                    statement.close();
            } catch (DatabaseConnectionException e1) {
                    e1.printStackTrace();
            }catch (SQLException e) {
                    releaseConnection(connection);
                    e.printStackTrace();
                    throw e;
            }
            releaseConnection(connection);
            return resultset;
    } */

    /**
     * f[^x[Xe[uւ̑}^폜p̃\bhłB
     *
     * @param sqlString SQL
     * @throws DatabaseConnectionException f[^x[XRlNV擾łȂꍇ
     * @throws SQLException f[^x[XANZXG[܂͂̑̃G[ꍇ
     */
    public synchronized void executeUpdate(final String sqlString)
        throws DatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;

        try {
            // RlNV擾
            connection = getConnection();
            statement = connection.createStatement();
            statement.execute(sqlString);

            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                connection.commit();
            } else {
                statement.execute(AbstractDataAccessObject.COMMIT);
            }
        } catch (DatabaseConnectionException e1) {
            e1.printStackTrace();
            throw e1;
        } catch (SQLException e) {
            if (connection != null) {
                releaseConnection(connection);
                connection = null;
            }

            // PostgreSQLł"Table does not exist"ł͏QƂȂ
            // e.printStackTrace();
            throw e;
        } finally {
            if (statement != null) {
                try {
                    statement.close();
                } catch (SQLException e2) {
                    e2.printStackTrace();
                    throw e2;
                }
            }

            if (connection != null) {
                // RlNV
                releaseConnection(connection);
                connection = null;
            }
        }
    }

    /**
     * f[^x[XRlNVPoolNXCX^XRlNVPool擾܂B
     *
     * @return connection Connection
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     */
    public synchronized Connection getConnection()
        throws DatabaseConnectionException {
        Connection connection =
            DatabaseConnectionPool.getInstance().getConnection(
                CONNECTION_TRY_COUNT);

        if (connection == null) {
            throw new DatabaseConnectionException("Can't get DB Connection");
        }

        return connection;
    }

    /**
     * f[^x[XRlNVPoolNXCX^XRlNVԋp܂B
     *
     * @param connection f[^x[XRlNV
     */
    public synchronized void releaseConnection(final Connection connection) {
        if (connection != null) {
            DatabaseConnectionPool.getInstance().releaseConnection(connection);
        }
    }
}
