/*
 * Created on 2004/07/15
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;



/**
 * e[uǗe[u𑀍삷郁\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DBTableManagement extends DBTableBase {
    /** e[uǗe[u */
    public static final String TABLEMANAGEMENT = "tableManagement";

    /** m[hIPAhXJ */
    public static final String IPADDRESS = "ipaddress";

    /** Ǘe[uJ */
    public static final String TABLE_NAME = "table_name";

    /** Limit`FbNJ */
    public static final String LIMIT_CHECK = "limit_check";

    /** Ǘe[uݒ */
    public static final String TABLE_CREATE_DATE = "table_create_date";

    /** Limit`FbNsDescription */
    public static final String LIMIT_YES = "yes";

    /** Limit`FbNȂDescription */
    public static final String LIMIT_NO = "no";

    /* MO */
    private static Logger logger = null;

    /**
     * e[uǗe[uNXCX^X𐶐܂B
     *
     */
    public DBTableManagement() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * e[uǗe[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        // e[u폜
        try {
            this.deleteTable(databaseAccess, TABLEMANAGEMENT);
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        try {
            // V[PXe[u폜
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropTableManagementSequenceSQL());

            // e[u
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateTableManagementTableSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * e[uǗe[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void dropTable() throws DatabaseConnectionException, SQLException {
        // DatabaseAccess databaseAccess = new DatabaseAccess();
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();

            // e[u폜
            this.deleteTable(databaseAccess, TABLEMANAGEMENT);

            // V[PXe[u폜
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropTableManagementSequenceSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * ǗΏۃe[ui[܂B
     *
     * @param ipaddress m[hIPAhX
     * @param tableName e[u
     * @param limitCheck l
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void put(String ipaddress, String tableName, String limitCheck)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // Timestamp format for HSQLDB
            Date date = Calendar.getInstance().getTime();
            DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            //sql̍쐬
            String sql =
                "INSERT INTO " + TABLEMANAGEMENT + " " + "( " + IPADDRESS
                + ", " + TABLE_NAME + ", " + LIMIT_CHECK + ", "
                + TABLE_CREATE_DATE + " )" + "VALUES ( '" + ipaddress + "','"
                + tableName + "','" + limitCheck + "','"
                + dateformat.format(date) + "' )";

            databaseAccess.executeUpdate(sql);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * w̃m[hIPAhX܂̓e[ũe[u폜܂B
     *
     * @param ipaddress m[hIPAhX
     * @param tableName e[u
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void delete(String ipaddress, String tableName)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            String sql = "";

            //sql̍쐬
            if (ipaddress != null) {
                this.deleteTargetTable(ipaddress);

                sql = "DELETE from " + TABLEMANAGEMENT + " where " + IPADDRESS
                    + "=" + "'" + ipaddress + "'";
            } else {
                sql = "DELETE from " + TABLEMANAGEMENT + " where " + TABLE_NAME
                    + "=" + "'" + tableName + "'";
            }

            databaseAccess.executeUpdate(sql);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * w̃m[hIPAhXɊւe[u폜܂B
     *
     * @param ipaddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void deleteTargetTable(String ipaddress)
        throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql;

            sql = "SELECT * from " + TABLEMANAGEMENT + " " + "where "
                + IPADDRESS + "=" + "'" + ipaddress + "'";

            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                String tableName = rs.getObject(TABLE_NAME).toString();

                this.deleteTable(dataaccess, tableName);
            }
        } catch (DatabaseConnectionException ex) {
            ex.printStackTrace();
            throw ex;
        } catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
            throw ex;
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }
    }
}
