package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.NetworkCameraInfo;




public final class DBTableNetworkCamera extends DBTableBase {

    public static final String CAMERA_TABLE_NAME = "network_camera";

    public static final String IPADDRESS = "ipAddress";

    public static final String USERNAME = "userName";

    public static final String PASSWORD = "password";

    public static final String REFRESH_PERIOD = "refreshPeriod";

    public static final String CONTROL_URL = "controlURL";

    public static final String JPEG_URL = "jpegURL";

    public static final String CAMERA_CURDATE = "curdate";


    /* MO */
    private static Logger logger = null;


    private static final String CAMERA_TABLE_ITEM =
        " (" 
        + USERNAME + " VARCHAR(255), " + PASSWORD + "  VARCHAR(255)," + REFRESH_PERIOD
        + " VARCHAR(255)," + CONTROL_URL + " VARCHAR(255)," + JPEG_URL
        + " VARCHAR(255)," + IPADDRESS + " VARCHAR(255)," 
        + CAMERA_CURDATE + " " + AbstractDataAccessObject.TIMESTAMP + " )";


    private final DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * PrintMIBe[u𑀍삷VOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTableNetworkCamera() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMP PrintMIB e[u𐶐܂B
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {



        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, CAMERA_TABLE_NAME);

            // f[^x[XEe[u쐬
            databaseAccess.executeUpdate(
                "CREATE TABLE " + CAMERA_TABLE_NAME
                + CAMERA_TABLE_ITEM);


        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * SNMP Print MIB e[u폜
     *
     * @param targetIpAddress m[hIPAhX
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
       

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            // ̃e[u폜
            this.deleteTable(databaseAccess, CAMERA_TABLE_NAME);
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * wm[hIP AddressPrint MIB񃊃XgԂ܂B
     *
     * @param tragetIpAddress m[hIPAhX
     * @return nodeIfList Interface MIB񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized NetworkCameraInfo findCamera(
        final String tragetIpAddress)
        throws SQLException, DatabaseConnectionException {


        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        NetworkCameraInfo networkCameraInfo = null;

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + CAMERA_TABLE_NAME
                + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'";

            // SQLXe[ggIuWFNg̍쐬
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {

            	networkCameraInfo = new NetworkCameraInfo();
            	networkCameraInfo.setIpaddress(
                        rs.getObject(IPADDRESS).toString());
            	networkCameraInfo.setUserName(rs.getObject(USERNAME).toString());
            	networkCameraInfo.setPassword(rs.getObject(PASSWORD).toString());
            	networkCameraInfo.setRefreshPeriod(rs.getObject(REFRESH_PERIOD).toString());
            	networkCameraInfo.setControlURL(
                    rs.getObject(CONTROL_URL).toString());
            	networkCameraInfo.setJpegURL(
                        rs.getObject(JPEG_URL).toString());
                
                break;

            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return networkCameraInfo;
    }

    /**
     * Print MIBCfbNXɃf[^x[XɊi[܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesList PrintMIBi[Xgzň
     * ziXgjOIDɑΉAXgɂ̓CfbNX̒li[
     * Ă
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾
     * oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void putCamera(
        final String tragetIpAddress, final NetworkCameraInfo networkCameraInfo)
        throws DatabaseConnectionException, SQLException {


        Date date = Calendar.getInstance().getTime();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {
            	                            
                if (
                    DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                 .equals(
                            AbstractDataAccessObject.DERBY)
                        || DatabaseAccessControlKind.getInstance()
                                                        .getDatabaseName()
                                                        .equals(
                            AbstractDataAccessObject.EMBEDDED_DERBY)) {
                	sql = "insert into " 
                    + CAMERA_TABLE_NAME + "( " + IPADDRESS  + ", " + USERNAME
                    + ", " + PASSWORD + ", " + REFRESH_PERIOD + ", " + CONTROL_URL
                    + ", " + JPEG_URL + ", "
                    + CAMERA_CURDATE + " )"
                    + " VALUES( " + "'"
                    + networkCameraInfo.getIpaddress() + "'," + "'"
                    + networkCameraInfo.getUserName() + "'," + "'"
                    + networkCameraInfo.getPassword() + "'," + "'"
                    + networkCameraInfo.getRefreshPeriod() + "'," + "'"
                    + networkCameraInfo.getControlURL() + "'," + "'"
                    + networkCameraInfo.getJpegURL() + "'," + "'"

                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                } else {
                	sql = "insert into "
                    + CAMERA_TABLE_NAME + "( " + IPADDRESS + ", " + USERNAME
                    + ", " + PASSWORD + ", " + REFRESH_PERIOD + ", " + CONTROL_URL
                    + ", " + JPEG_URL + ", "
                    +  CAMERA_CURDATE + " )"
                    + " VALUES( " + "'"

                    + networkCameraInfo.getIpaddress() + "'," + "'"
                    + networkCameraInfo.getUserName() + "'," + "'"
                    + networkCameraInfo.getPassword() + "'," + "'"
                    + networkCameraInfo.getRefreshPeriod() + "'," + "'"
                    + networkCameraInfo.getControlURL() + "'," + "'"
                    +networkCameraInfo.getJpegURL() + "'," + "'"

                    + simpleDateformat.format(date) + "'" + ")";
                    databaseAccess.executeUpdate(sql);
                }

        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw ex;
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress + " SQL=" + sql);
            throw e;
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * Print MIBXV܂B
     * Print MIB񂪕ωꍇɂ́AA[ʒm܂B
     *
     * @param tragetIpAddress IPAhX
     * @param interfacesArrayList Listz̈OIDɑΉAz񖈂
     * IndexɑΉPrintMIB񂪓
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void updateCamera(
        final String tragetIpAddress, final NetworkCameraInfo networkCameraInfo)
        throws DatabaseConnectionException, SQLException {

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {

            updateCameraTabel(
                databaseAccess, networkCameraInfo);
        } catch (SQLException ex) {
            logger.warning(ex.getMessage() + " IP=" + tragetIpAddress);
            ex.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " IP=" + tragetIpAddress);
            e.printStackTrace();
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }





    /**
     * PrintMIBe[uXV܂B
     *
     * @param databaseAccess f[^x[XANZXIuWFNg
     * @param interfacesArrayList PrintMIBi[Xg
     * @param ipaddressTablename e[u
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void updateCameraTabel(
        DatabaseAccess databaseAccess, final NetworkCameraInfo networkCameraInfo)
        throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();

            if (
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                                             .equals(
                        AbstractDataAccessObject.DERBY)
                    || DatabaseAccessControlKind.getInstance().getDatabaseName()
                                                    .equals(
                        AbstractDataAccessObject.EMBEDDED_DERBY)) {
                databaseAccess.executeUpdate(
                    "UPDATE " + CAMERA_TABLE_NAME
                    + " set "
                    
                    + IPADDRESS + "='"
                    + networkCameraInfo.getIpaddress() + "', "
                    + USERNAME + "='"
                    + networkCameraInfo.getUserName() + "', "
                    + PASSWORD + "='"
                    + networkCameraInfo.getPassword() + "', "
                    + REFRESH_PERIOD + "='"
                    + networkCameraInfo.getRefreshPeriod() + "', "
                    + CONTROL_URL + "='"
                    + networkCameraInfo.getControlURL() + "', "
                    + JPEG_URL + "='"
                    + networkCameraInfo.getJpegURL() + "', "
                    
                    
                    + CAMERA_CURDATE + "='"
                    + simpleDateformat.format(date) + "'"
                    + " where " + IPADDRESS + "=" + "'" + networkCameraInfo.getIpaddress() + "'"
                    + " ");
            } else {
                databaseAccess.executeUpdate(
                    "UPDATE " + CAMERA_TABLE_NAME
                    + " set " + IPADDRESS + "='"
                    + networkCameraInfo.getIpaddress() + "', "
                    + USERNAME + "='"
                    + networkCameraInfo.getUserName() + "', "
                    + PASSWORD + "='"
                    + networkCameraInfo.getPassword() + "', "
                    + REFRESH_PERIOD + "='"
                    + networkCameraInfo.getRefreshPeriod() + "', "
                    + CONTROL_URL + "='"
                    + networkCameraInfo.getControlURL() + "', "
                    + JPEG_URL + "='"
                    + networkCameraInfo.getJpegURL() + "', "
                   
                    + CAMERA_CURDATE + "='"
                    + simpleDateformat.format(date) + "'"
                    + " where " + IPADDRESS + "=" + "'" + networkCameraInfo.getIpaddress() + "'"
                    + " ");
                
            }
        
    }

    /**
     * Printe[ȗSĂIndex폜܂B
     * ́APrint܂́AIndexԍωꍇŁA
     * e[uXVoȂ̂ňUAe[u폜čēxA
     * e[u邽߂ɌĂ΂܂B
     *
     *
     * @param tragetIpAddress m[hIPAhX
     * @param preOidList O̎悵OIDCX^XXg
     * @return
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteCameraNodeIP(
        final String tragetIpAddress)
        throws DatabaseConnectionException, SQLException {

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
                String sql = "";
                //sql̍쐬
                sql = "DELETE from " + CAMERA_TABLE_NAME
                    + " where " + IPADDRESS + "=" + "'" + tragetIpAddress + "'";
                databaseAccess.executeUpdate(sql);           
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }



    /**
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static DBTableNetworkCamera getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableNetworkCamera RESOURCE = new DBTableNetworkCamera();
    }
}
